% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.safe}
\alias{pal.safe}
\title{Show a palette/colormap for black/white and colorblind safety}
\usage{
pal.safe(pal, n = 100, main = NULL)
}
\arguments{
\item{pal}{A palette function or a vector of colors.}

\item{n}{The number of colors to display for palette functions.}

\item{main}{Title to display at the top of the test image}
}
\value{
None.
}
\description{
A single palette/colormap is shown 
(1) without any modifications 
(2) in black-and-white as if photocopied 
(3) as seen by deutan color-blind
(4) as seen by protan color-blind
(5) as seen by tritan color-blind
}
\details{
Rates of colorblindness in women are low, but in men the rates are
around 3 to 7 percent, depending on the race.

What to look for:

1. Are colors still unique when viewed in less-than full color?

2. Is a sequential colormap still sequential?
}
\examples{
pal.safe(glasbey)
pal.safe(rainbow, main="rainbow") # Really, really bad
pal.safe(cubicyf(100), main="cubicyf")
pal.safe(parula, main="parula")

}
\author{
Kevin Wright
}
\references{
None
}

