% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_get_record.R
\name{pg_get_record}
\alias{pg_get_record}
\title{Get record from the Pangaea repository}
\usage{
pg_get_record(identifier, prefix = "oai_dc", as = "df", ...)
}
\arguments{
\item{identifier}{Dataset identifier. See Examples.}

\item{prefix}{A character string to specify the metadata format in OAI-PMH
requests issued to the repository. The default (\code{oai_dc}) corresponds
to the mandatory OAI unqualified Dublin Core metadata schema.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl debugging options passed on to \code{\link[oai:get_records]{oai::get_records()}}}
}
\value{
XML character string, data.frame, or list, depending on what
requested with the \code{as} parameter
}
\description{
Get record from the Pangaea repository
}
\examples{
\dontrun{
pg_get_record(identifier = "oai:pangaea.de:doi:10.1594/PANGAEA.788382")
pg_get_record(identifier = "oai:pangaea.de:doi:10.1594/PANGAEA.269656",
prefix="iso19139")
pg_get_record(identifier = "oai:pangaea.de:doi:10.1594/PANGAEA.269656",
prefix="dif")

# invalid record id
# pg_get_record(identifier = "oai:pangaea.de:doi:10.1594/PANGAEA.11111")
# pg_get_record(identifier = "oai:pangaea.de:doi:10.1594/PANGAEA.11111",
#   prefix="adfadf")
}
}
\references{
\href{https://www.openarchives.org/pmh/}{OAI-PMH documentation}
}
\seealso{
wraps \code{\link[oai:get_records]{oai::get_records()}}

Other oai methods: 
\code{\link{pg_identify}()},
\code{\link{pg_list_identifiers}()},
\code{\link{pg_list_metadata_formats}()},
\code{\link{pg_list_records}()},
\code{\link{pg_list_sets}()}
}
\concept{oai methods}
