% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Context.R
\name{Context}
\alias{Context}
\title{Context}
\description{
This class represents the base context for interacting with
\code{\link{Backend}} implementations via the \code{\link{Service}} interface.
}
\details{
This class is a vanilla wrapper around a \code{\link{Backend}} implementation.
It registers a backend instance and forwards all \code{\link{Service}} methods
calls to the backend instance. Subclasses can override any of the
\code{\link{Service}} methods to decorate the backend instance with additional
functionality (e.g., see the \code{\link{ProgressTrackingContext}} class).
}
\examples{
# Define a task to run in parallel.
task <- function(x, y) {
    # Sleep a bit.
    Sys.sleep(0.25)

    # Return the result of a computation.
    return(x + y)
}

# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create a backend factory.
backend_factory <- BackendFactory$new()

# Get a synchronous backend instance.
backend <- backend_factory$get("sync")

# Create a base context object.
context <- Context$new()

# Register the backend with the context.
context$set_backend(backend)

# From now all, all backend operations are intercepted by the context.

# Start the backend.
context$start(specification)

# Run a task in parallel (i.e., approx. 1.25 seconds).
context$sapply(x = 1:10, fun = task, y = 10)

# Get the task output.
context$get_output()

# Close the backend.
context$stop()

# Get an asynchronous backend instance.
backend <- backend_factory$get("async")

# Register the backend with the same context object.
context$set_backend(backend)

# Start the backend reusing the specification object.
context$start(specification)

# Run a task in parallel (i.e., approx. 1.25 seconds).
context$sapply(x = 1:10, fun = task, y = 10)

# Get the task output.
backend$get_output(wait = TRUE)

# Close the backend.
context$stop()

}
\seealso{
\code{\link{ProgressTrackingContext}}, \code{\link{Service}},
\code{\link{Backend}}, and \code{\link{SyncBackend}}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{backend}}{The \code{\link{Backend}} object registered with the
context.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Context-set_backend}{\code{Context$set_backend()}}
\item \href{#method-Context-start}{\code{Context$start()}}
\item \href{#method-Context-stop}{\code{Context$stop()}}
\item \href{#method-Context-clear}{\code{Context$clear()}}
\item \href{#method-Context-peek}{\code{Context$peek()}}
\item \href{#method-Context-export}{\code{Context$export()}}
\item \href{#method-Context-evaluate}{\code{Context$evaluate()}}
\item \href{#method-Context-sapply}{\code{Context$sapply()}}
\item \href{#method-Context-get_output}{\code{Context$get_output()}}
\item \href{#method-Context-clone}{\code{Context$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-set_backend"></a>}}
\if{latex}{\out{\hypertarget{method-Context-set_backend}{}}}
\subsection{Method \code{set_backend()}}{
Set the backend instance to be used by the context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$set_backend(backend)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{backend}}{An object of class \code{\link{Backend}} that
implements the \code{\link{Service}} interface.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-start"></a>}}
\if{latex}{\out{\hypertarget{method-Context-start}{}}}
\subsection{Method \code{start()}}{
Start the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$start(specification)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{specification}}{An object of class \code{\link{Specification}}
that contains the backend configuration.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The resulting backend must be stored in the
\code{.cluster} private field on the \code{\link{Backend}} abstract class,
and accessible to any concrete backend implementations via the active
binding \code{cluster}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-stop"></a>}}
\if{latex}{\out{\hypertarget{method-Context-stop}{}}}
\subsection{Method \code{stop()}}{
Stop the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$stop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-clear"></a>}}
\if{latex}{\out{\hypertarget{method-Context-clear}{}}}
\subsection{Method \code{clear()}}{
Remove all objects from the backend. This function is equivalent to
calling \code{rm(list = ls(all.names = TRUE))} on each node in the
backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-peek"></a>}}
\if{latex}{\out{\hypertarget{method-Context-peek}{}}}
\subsection{Method \code{peek()}}{
Inspect the backend for variables available in the \code{.GlobalEnv}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$peek()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
This method returns a list of character vectors, where each element
corresponds to a node in the backend. The character vectors contain
the names of the variables available in the \code{.GlobalEnv} on each
node.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-export"></a>}}
\if{latex}{\out{\hypertarget{method-Context-export}{}}}
\subsection{Method \code{export()}}{
Export variables from a given environment to the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$export(variables, environment)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{variables}}{A character vector of variable names to export.}

\item{\code{environment}}{An environment object from which to export the
variables.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-evaluate"></a>}}
\if{latex}{\out{\hypertarget{method-Context-evaluate}{}}}
\subsection{Method \code{evaluate()}}{
Evaluate an arbitrary expression on the backend.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$evaluate(expression)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expression}}{An unquoted expression to evaluate on the backend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns the result of the expression evaluation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-sapply"></a>}}
\if{latex}{\out{\hypertarget{method-Context-sapply}{}}}
\subsection{Method \code{sapply()}}{
Run a task on the backend akin to \code{\link[parallel:clusterApply]{parallel::parSapply()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$sapply(x, fun, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector (i.e., usually of integers) to pass to the \code{fun}
function.}

\item{\code{fun}}{A function to apply to each element of \code{x}.}

\item{\code{...}}{Additional arguments to pass to the \code{fun} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns void. The output of the task execution must be
stored in the private field \code{.output} on the \code{\link{Backend}}
abstract class, and is accessible via the \code{get_output()} method.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-Context-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get the output of the task execution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$get_output(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments to pass to the backend registered
with the context. This is useful for backends that require additional
arguments to fetch the output (e.g., \code{\link[=AsyncBackend]{AsyncBackend$get_output(wait = TRUE)}}).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method fetches the output of the task execution after calling
the \code{sapply()} method. It returns the output and immediately removes
it from the backend. Therefore, subsequent calls to this method are
not advised. This method should be called after the execution of a
task.
}

\subsection{Returns}{
A vector or list of the same length as \code{x} containing the results of
the \code{fun}. It resembles the format of \code{\link[base:lapply]{base::sapply()}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Context-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Context$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
