% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{Domain}
\alias{Domain}
\alias{p_int}
\alias{p_dbl}
\alias{p_uty}
\alias{p_lgl}
\alias{p_fct}
\title{Domain: Parameter Range without an Id}
\usage{
p_int(
  lower = -Inf,
  upper = Inf,
  special_vals = list(),
  default = NO_DEF,
  tags = character(),
  depends = NULL,
  trafo = NULL
)

p_dbl(
  lower = -Inf,
  upper = Inf,
  special_vals = list(),
  default = NO_DEF,
  tags = character(),
  depends = NULL,
  trafo = NULL
)

p_uty(
  default = NO_DEF,
  tags = character(),
  custom_check = NULL,
  depends = NULL,
  trafo = NULL
)

p_lgl(
  special_vals = list(),
  default = NO_DEF,
  tags = character(),
  depends = NULL,
  trafo = NULL
)

p_fct(
  levels,
  special_vals = list(),
  default = NO_DEF,
  tags = character(),
  depends = NULL,
  trafo = NULL
)
}
\arguments{
\item{lower}{(\code{numeric(1)})\cr
Lower bound, can be \code{-Inf}.}

\item{upper}{(\code{numeric(1)})\cr
Upper bound can be \code{+Inf}.}

\item{special_vals}{(\code{list()})\cr
Arbitrary special values this parameter is allowed to take, to make it
feasible. This allows extending the domain of the parameter. Note that
these values are only used in feasibility checks, neither in generating
designs nor sampling.}

\item{default}{(\code{any})\cr
Default value. Can be from the domain of the parameter or an element of
\code{special_vals}. Has value \link{NO_DEF} if no default exists. \code{NULL} can be a
valid default.
The value has no effect on \code{ParamSet$values} or the behavior of
\code{ParamSet$check()}, \verb{$test()} or \verb{$assert()}.
The \code{default} is intended to be used for documentation purposes.
`}

\item{tags}{(\code{character()})\cr
Arbitrary tags to group and subset parameters. Some tags serve a special
purpose:\cr
\itemize{
\item \code{"required"} implies that the parameters has to be given when setting
\code{values} in \link{ParamSet}.
}}

\item{depends}{(\code{call} | \code{expression})\cr
An expression indicating a requirement for the parameter that will be constructed from this. Can be given as an
expression (using \code{quote()}), or the expression can be entered directly and will be parsed using NSE (see
examples). The expression may be of the form \verb{<Param> == <value>} or \verb{<Param> \%in\% <values>}, which will result in
dependencies according to \verb{ParamSet$add_dep(on = "<Param>", cond = CondEqual$new(<value>))} or
\verb{ParamSet$add_dep(on = "<Param>", cond = CondAnyOf$new(<values>))}, respectively (see \code{\link{CondEqual}},
\code{\link{CondAnyOf}}). The expression may also contain multiple conditions separated by \code{&&}.}

\item{trafo}{(\code{function})\cr
Single argument function performing the transformation of a parameter. When the \code{Domain} is used to construct a
\code{\link{ParamSet}}, this transformation will be applied to the corresponding parameter as part of the \verb{$trafo} function.}

\item{custom_check}{(\verb{function()})\cr
Custom function to check the feasibility.
Function which checks the input.
Must return 'TRUE' if the input is valid and a \code{character(1)} with the error message otherwise.
This function should \emph{not} throw an error.
Defaults to \code{NULL}, which means that no check is performed.}

\item{levels}{(\code{character} | \code{atomic} | \code{list})\cr
Allowed categorical values of the parameter. If this is not a \code{character}, then a \code{trafo} is generated that
converts the names (if not given: \code{as.character()} of the values) of the \code{levels} argument to the values.
This trafo is then performed \emph{before} the function given as the \code{trafo} argument.}
}
\value{
A \code{Domain} object.
}
\description{
A \code{Domain} object is a representation of a single dimension of a \code{\link{ParamSet}}. \code{Domain} objects are used to construct
\code{\link{ParamSet}}s, either through the \code{\link[=ps]{ps()}} short form, or through the \code{\link{ParamSet}}\verb{$search_space()} mechanism (see
\code{\link[=to_tune]{to_tune()}}). \code{Domain} corresponds to a \code{\link{Param}} object, except it does not have an \verb{$id}, and it \emph{does} have a
\code{trafo} and dependencies (\code{depends}) associated with it. For each of the basic \code{\link{Param}} classes (\code{\link{ParamInt}},
\code{\link{ParamDbl}}, \code{\link{ParamLgl}}, \code{\link{ParamFct}}, and \code{\link{ParamUty}}) there is a function constructing a \code{Domain} object
(\code{p_int()}, \code{p_dbl()}, \code{p_lgl()}, \code{p_fct()}, \code{p_uty()}). They each have the same arguments as the corresponding
\code{\link{Param}} \verb{$new()} function, except without the \code{id} argument, and with the the additional parameters \code{trafo}, and
\code{depends}.

\code{Domain} objects are representations of parameter ranges and are intermediate objects to be used in short form
constructions in \code{\link[=to_tune]{to_tune()}} and \code{\link[=ps]{ps()}}. Because of their nature, they should not be modified by the user.
The \code{Domain} object's internals are subject to change and should not be relid upon.
}
\details{
The \code{p_fct} function admits a \code{levels} argument that goes beyond the \code{levels} accepted by \code{\link{ParamFct}}\verb{$new()}.
Instead of a \code{character} vector, any atomic vector or list (optionally named) may be given. (If the value is a list
that is not named, the names are inferred using \code{as.character()} on the values.) The resulting \code{Domain} will
correspond to a range of values given by the names of the \code{levels} argument with a \code{trafo} that maps the \code{character}
names to the arbitrary values of the \code{levels} argument.
}
\examples{
params = ps(
  unbounded_integer = p_int(),
  bounded_double = p_dbl(0, 10),
  half_bounded_integer = p_dbl(1),
  half_bounded_double = p_dbl(upper = 1),
  double_with_trafo = p_dbl(-1, 1, trafo = exp),
  extra_double = p_dbl(0, 1, special_vals = list("xxx"), tags = "tagged"),
  factor_param = p_fct(c("a", "b", "c")),
  factor_param_with_implicit_trafo = p_fct(list(a = 1, b = 2, c = list()))
)
print(params)

params$trafo(list(
  bounded_double = 1,
  double_with_trafo = 1,
  factor_param = "c",
  factor_param_with_implicit_trafo = "c"
))
}
\seealso{
Other ParamSet construction helpers: 
\code{\link{ps}()},
\code{\link{to_tune}()}
}
\concept{ParamSet construction helpers}
