% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_core_als.R
\name{parafac_core_als}
\alias{parafac_core_als}
\title{Internal PARAFAC alternating least-squares (ALS) core algorithm}
\usage{
parafac_core_als(Tensor, nfac, init, maxit = 500, ctol = 1e-04)
}
\arguments{
\item{Tensor}{Tensor data object}

\item{nfac}{Number of components to compute}

\item{init}{Initialization from \link{initializePARAFAC}.}

\item{maxit}{Maximum number of iterations to run (default 500).}

\item{ctol}{Loss function tolerance for convergence (default 1e-4)}
}
\value{
List containing a Fac object and the loss per iteration
}
\description{
Internal PARAFAC alternating least-squares (ALS) core algorithm
}
\examples{
A = array(rnorm(108*2), c(108,2))
B = array(rnorm(100*2), c(100,2))
C = array(rnorm(10*2), c(10,2))
Tensor = reinflateTensor(A, B, C)
init = initializePARAFAC(Tensor, 2)
model = parafac_core_als(Tensor, 2, init)
}
