% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_DirichletReg.R, R/methods_averaging.R,
%   R/methods_betareg.R, R/methods_cgam.R, R/methods_ordinal.R
\name{p_value.DirichletRegModel}
\alias{p_value.DirichletRegModel}
\alias{p_value.averaging}
\alias{p_value.betareg}
\alias{p_value.cgam}
\alias{p_value.clm2}
\title{p-values for Models with Special Components}
\usage{
\method{p_value}{DirichletRegModel}(model, component = c("all", "conditional", "precision"), ...)

\method{p_value}{averaging}(model, component = c("conditional", "full"), ...)

\method{p_value}{betareg}(model, component = c("all", "conditional", "precision"), ...)

\method{p_value}{cgam}(model, component = c("all", "conditional", "smooth_terms"), ...)

\method{p_value}{clm2}(model, component = c("all", "conditional", "scale"), ...)
}
\arguments{
\item{model}{A statistical model.}

\item{component}{Should all parameters, parameters for the conditional model,
precision- or scale-component or smooth_terms be returned? \code{component}
may be one of \code{"conditional"}, \code{"precision"}, \code{"scale"},
\code{"smooth_terms"}, \code{"full"} or \code{"all"} (default).}

\item{...}{Additional arguments}
}
\value{
The p-values.
}
\description{
This function attempts to return, or compute, p-values of models
with special model components.
}
