% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finders.R
\name{finders}
\alias{finders}
\alias{find_whitespace}
\alias{find_env}
\alias{find_macro}
\alias{find_catcode}
\alias{find_tags}
\alias{find_char}
\title{Miscellaneous low-level finders}
\usage{
find_whitespace(items)

find_env(items, envtypes)

find_macro(items, macros)

find_catcode(items, codes)

find_tags(items, tags)

find_char(items, char)
}
\arguments{
\item{items}{A list of latex items.}

\item{envtypes}{Which types of environment to look for.}

\item{macros}{Which types of macros to look for.}

\item{codes}{Which codes to look for.}

\item{tags}{Which tags to look for.}

\item{char}{Which character to look for.}
}
\value{
\code{find_whitespace()} returns the indices of
whitespace in \code{items}.

\code{find_env()} returns the indices within \code{items}
of environments in \code{envtypes}.

\code{find_macro()} returns the index within \code{items}
of instances in \code{macros}.

\code{find_catcode()} returns the index within \code{items}.
of specials matching \code{code}.

\code{find_tags()} returns the index within \code{items}.
of items with tags matching \code{tags}.

\code{find_char()} returns the index within \code{items}
of characters matching \code{char}.  Only characters
marked as SPECIAL by the parser will be found.
}
\description{
Miscellaneous low-level finders
}
