% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional_hazards.R
\name{proportional_hazards}
\alias{proportional_hazards}
\title{Proportional hazards regression}
\usage{
proportional_hazards(
  mode = "censored regression",
  engine = "survival",
  penalty = NULL,
  mixture = NULL
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
The only possible value for this model is "censored regression".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{penalty}{A non-negative number representing the total
amount of regularization (specific engines only).}

\item{mixture}{A number between zero and one (inclusive) denoting the
proportion of L1 regularization (i.e. lasso) in the model.
\itemize{
\item \code{mixture = 1} specifies a pure lasso model,
\item \code{mixture = 0}  specifies a ridge regression model, and
\item \verb{0 < mixture < 1} specifies an elastic net model, interpolating lasso and ridge.
}

Available for specific engines only.}
}
\description{
\code{proportional_hazards()} defines a model for the hazard function
as a multiplicative function of covariates times a baseline hazard. This
function can fit censored regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("proportional_hazards")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Since survival models typically involve censoring (and require the use of
\code{\link[survival:Surv]{survival::Surv()}} objects), the \code{\link[=fit.model_spec]{fit.model_spec()}} function will require that the
survival model be specified via the formula interface.

Proportional hazards models include the Cox model.
}
\examples{
show_engines("proportional_hazards")

proportional_hazards(mode = "censored regression")
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("proportional_hazards")}
}
\keyword{internal}
