% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time.R
\name{parttime}
\alias{parttime}
\title{Create a parttime object}
\usage{
parttime(
  year = NA,
  month = NA,
  day = NA,
  hour = NA,
  min = NA,
  sec = NA,
  tzhour = interpret_tz(getOption("parttime.assume_tz_offset", NA))/60
)
}
\arguments{
\item{year}{numeric vector to use for partial time year component}

\item{month}{numeric vector to use for partial time month component}

\item{day}{numeric vector to use for partial time day component}

\item{hour}{numeric vector to use for partial time hour component}

\item{min}{numeric vector to use for partial time min component}

\item{sec}{numeric vector to use for partial time sec component}

\item{tzhour}{numeric vector to use for partial time tzhour component}
}
\value{
A \code{partial_time} object. See Details section for further information.
}
\description{
Create a parttime object
}
\details{
A \code{parttime} object (short for its class name, \code{partial_time}), is a vector
representation of a numeric matrix containing rows for each vector element
and a column for each datetime field.

To inspect the internal representation of a \code{partial_time} class vector, you
can use \verb{vctrs::field(<pttm>, "pttm_mat")}.
}
\examples{
parttime(2019)

}
