\name{marbio}
\alias{marbio}

\encoding{latin1}

\non_function{}
\title{ Several zooplankton taxa measured across a transect }
\usage{data(marbio)}
\description{
The \code{marbio} data frame has 68 rows (stations) and 24 columns (taxonomic zooplankton groups).
Abundances are expressed in no per cubic meter of seawater.
}
\format{
  This data frame contains the following columns giving abundance of:
  \describe{
    \item{Acartia}{Acartia clausi - herbivorous}
    \item{AdultsOfCalanus}{Calanus helgolandicus (adults) - herbivorous}
    \item{Copepodits1}{Idem (copepodits 1) - omnivorous}
    \item{Copepodits2}{Idem (copepodits 2) - omnivorous}
    \item{Copepodits3}{Idem (copepodits 3) - omnivorous}
    \item{Copepodits4}{Idem (copepodits 4) - omnivorous}
    \item{Copepodits5}{Idem (copepodits 5) - omnivorous}
    \item{ClausocalanusA}{Clausocalanus size class A - herbivorous}
    \item{ClausocalanusB}{Clausocalanus size class B - herbivorous}
    \item{ClausocalanusC}{Clausocalanus size class C - herbivorous}
    \item{AdultsOfCentropages}{Centropages tipicus (adults) - omnivorous}
    \item{JuvenilesOfCentropages}{Centropages typicus (juv.) - omnivorous}
    \item{Nauplii}{Nauplii of copepods - filter feeders}
    \item{Oithona}{Oithona sp. - carnivorous}
    \item{Acanthaires}{Various species of acanthaires - misc}
    \item{Cladocerans}{Various species of cladocerans - carnivorous}
    \item{EchinodermsLarvae}{Larvae of echinoderms - filter feeders}
    \item{DecapodsLarvae}{Larvae of decapods - omnivorous}
    \item{GasteropodsLarvae}{Larvae of gastropods - filter feeders}
    \item{EggsOfCrustaceans}{Eggs of crustaceans - misc}
    \item{Ostracods}{Various species of ostracods - omnivorous}
    \item{Pteropods}{Various species of pteropods - herbivorous}
    \item{Siphonophores}{Various species of siphonophores - carnivorous}
    \item{BellsOfCalycophores}{Bells of calycophores - misc}
  }
}
\details{
This dataset corresponds to a single transect sampled with a plankton net across the Ligurian Sea front in the Mediterranean Sea, between Nice (France) and Calvi (Corsica). The transect extends from the Cap Ferrat (close to Nice) to about 65 km offshore in the direction of Calvi (along a bearing of 123). 68 regularly spaced samples where collected on this transect. For more information about the water masses and their physico-chemical characteristics, see the marphy dataset.
}
\source{
Boucher, J., F. Ibanez & L. Prieur (1987) \emph{Daily and seasonal variations in the spatial distribution of zooplankton populations in relation to the physical structure in the Ligurian Sea Front.} Journal of Marine Research, 45:133-173.
}
\references{
Fromentin, J.-M., F. Ibanez & P. Legendre (1993) \emph{A phytosociological method for interpreting plankton data.} Marine Ecology Progress Series, 93:285-306.
}

\seealso{ \code{\link{marphy}} }

\keyword{datasets}
