% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{myeloma_input}
\alias{myeloma_input}
\title{Example Input for Myeloma Analysis (Mus Musculus)}
\format{
A data frame with 45 rows and 2 variables: \describe{
\item{Gene_Symbol}{MGI gene symbols of the differentially-expressed genes}
\item{FDR}{adjusted p values, via the Benjamini & Hochberg (1995) method}
}
}
\source{
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE99393}
}
\usage{
myeloma_input
}
\description{
A dataset containing the differentially-expressed genes and adjusted p-values
for the GEO dataset GSE99393. The RNA microarray experiment was perform to
detail the global program of gene expression underlying polarization of
myeloma-associated macrophages by CSF1R antibody treatment. The samples were
6 murine bone marrow derived macrophages co-cultured with myeloma cells
(myeloma-associated  macrophages), 3 of which were treated with CSF1R
antibody (treatment group) and the rest were treated with control IgG
antibody (control group). In this dataset, differentially-expressed genes
with |logFC| >= 2 and FDR < 0.05 are presented.
\emph{Generated on Nov 1, 2019.}
}
\seealso{
\code{\link{myeloma_output}} for the example mmu enrichment output.
\code{\link[pathfindR]{run_pathfindR}} for details on the pathfindR enrichment analysis.
}
\keyword{datasets}
