% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_functions.R
\name{combine_pathfindR_results}
\alias{combine_pathfindR_results}
\title{Combine 2 pathfindR Results}
\usage{
combine_pathfindR_results(result_A, result_B, plot_common = TRUE)
}
\arguments{
\item{result_A}{data frame of first pathfindR enrichment results}

\item{result_B}{data frame of second pathfindR enrichment results}

\item{plot_common}{boolean to indicate whether or not to plot the term-gene
graph of the common terms (default=\code{TRUE})}
}
\value{
Data frame of combined pathfindR enrichment results. Columns are: \describe{
  \item{ID}{ID of the enriched term}
  \item{Term_Description}{Description of the enriched term}
  \item{Fold_Enrichment_A}{Fold enrichment value for the enriched term (Calculated using ONLY the input genes)}
  \item{occurrence_A}{the number of iterations that the given term was found to enriched over all iterations}
  \item{lowest_p_A}{the lowest adjusted-p value of the given term over all iterations}
  \item{highest_p_A}{the highest adjusted-p value of the given term over all iterations}
  \item{Up_regulated_A}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated_A}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Fold_Enrichment_B}{Fold enrichment value for the enriched term (Calculated using ONLY the input genes)}
  \item{occurrence_B}{the number of iterations that the given term was found to enriched over all iterations}
  \item{lowest_p_B}{the lowest adjusted-p value of the given term over all iterations}
  \item{highest_p_B}{the highest adjusted-p value of the given term over all iterations}
  \item{Up_regulated_B}{the up-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{Down_regulated_B}{the down-regulated genes in the input involved in the given term's gene set, comma-separated}
  \item{combined_p}{the combined p value (via Fisher's method)}
  \item{status}{whether the term is found in both analyses ("common"), found only in the first ("A only") or found only in the second ("B only)}
}
By default, the function also displays the term-gene graph of the common terms
}
\description{
Combine 2 pathfindR Results
}
\examples{
combined_results <- combine_pathfindR_results(RA_output, RA_comparison_output)
}
