% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_functions.R
\name{visualize_hsa_KEGG}
\alias{visualize_hsa_KEGG}
\title{Visualize Human KEGG Pathways}
\usage{
visualize_hsa_KEGG(
  hsa_kegg_ids,
  input_processed,
  max_to_plot = NULL,
  scale_vals = TRUE,
  node_cols = NULL,
  quiet = TRUE,
  key_gravity = "northeast",
  logo_gravity = "southeast"
)
}
\arguments{
\item{hsa_kegg_ids}{hsa KEGG ids of pathways to be colored and visualized}

\item{input_processed}{input data processed via \code{\link{input_processing}}}

\item{max_to_plot}{The number of hsa kegg pathways (from beginning
until the \code{max_to_plot}th id) to visualize. If NULL, visualizes all
(default = NULL)}

\item{scale_vals}{should change values be scaled? (default = \code{TRUE})}

\item{node_cols}{low, middle and high color values for coloring the pathway nodes
(default = \code{NULL}). If \code{node_cols=NULL}, the low, middle and high color
are set as "green", "gray" and "red". If all change values are 1e6 (in case no
changes are supplied, this dummy value is assigned by
\code{\link{input_processing}}), only one color ("#F38F18" if NULL) is used.}

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and the
progress bar while downloading file(s)}

\item{key_gravity}{gravity value (character) for the color key legend placement
(see \code{\link[magick]{gravity_types}})}

\item{logo_gravity}{gravity value (character) for the logo placement
(see \code{\link[magick]{gravity_types}})}
}
\value{
Creates colored visualizations of the enriched human KEGG pathways
and saves them in the folder "term_visualizations" under the current working
directory.
}
\description{
Visualize Human KEGG Pathways
}
\examples{
\dontrun{
visualize_hsa_KEGG(hsa_kegg_ids, input_processed)
}
}
\seealso{
See \code{\link{visualize_terms}} for the wrapper function for
creating enriched term diagrams. See \code{\link{run_pathfindR}} for the
wrapper function of the pathfindR enrichment workflow.
}
