% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{combined_results_graph}
\alias{combined_results_graph}
\title{Combined Results Graph}
\usage{
combined_results_graph(
  combined_df,
  selected_terms = "common",
  use_description = FALSE,
  layout = "stress",
  node_size = "num_genes"
)
}
\arguments{
\item{combined_df}{Data frame of combined pathfindR enrichment results}

\item{selected_terms}{the vector of selected terms for creating the graph
(either IDs or term descriptions). If set to \code{"common"}, all of the
common terms are used. (default = "common")}

\item{use_description}{Boolean argument to indicate whether term descriptions
(in the "Term_Description" column) should be used. (default = \code{FALSE})}

\item{layout}{The type of layout to create (see \code{\link[ggraph]{ggraph}} for details. Default = "stress")}

\item{node_size}{Argument to indicate whether to use number of significant genes ("num_genes")
or the -log10(lowest p value) ("p_val") for adjusting the node sizes (default = "num_genes")}
}
\value{
a  \code{\link[ggraph]{ggraph}} object containing the combined term-gene graph.
 Each node corresponds to an enriched term (orange if common, different shades of blue otherwise),
 an up-regulated gene (green), a down-regulated gene (red) or
 a conflicting (i.e. up in one analysis, down in the other or vice versa) gene
 (gray). An edge between a term and a gene indicates
 that the given term involves the gene. Size of a term node is proportional
 to either the number of genes (if \code{node_size = "num_genes"}) or
 the -log10(lowest p value) (if \code{node_size = "p_val"}).
}
\description{
Combined Results Graph
}
\examples{
combined_results <- combine_pathfindR_results(
  example_pathfindR_output,
  example_comparison_output,
  plot_common = FALSE
)
g <- combined_results_graph(combined_results, selected_terms = sample(combined_results$ID, 3))
}
