% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcMatrix.R
\name{pcMatrix}
\alias{pcMatrix}
\title{Pattern Causality Matrix Analysis}
\usage{
pcMatrix(
  dataset,
  E,
  tau,
  metric = "euclidean",
  h,
  weighted = TRUE,
  distance_fn = NULL,
  state_space_fn = NULL,
  verbose = FALSE,
  n_cores = 1
)
}
\arguments{
\item{dataset}{Matrix or data frame of time series}

\item{E}{Integer; embedding dimension}

\item{tau}{Integer; time delay}

\item{metric}{Character; distance metric ("euclidean", "manhattan", "maximum")}

\item{h}{Integer; prediction horizon}

\item{weighted}{Logical; whether to use weighted causality}

\item{distance_fn}{Optional custom distance function}

\item{state_space_fn}{Optional custom state space reconstruction function}

\item{verbose}{Logical; whether to print progress}

\item{n_cores}{Integer; number of cores for parallel computation}
}
\value{
A pc_matrix object containing causality matrices
}
\description{
Analyzes pattern causality relationships between multiple time series
by computing pairwise causality measures and organizing them into matrices.
}
\details{
Compute Pattern Causality Matrix Analysis

The function performs these key steps:
\itemize{
\item Validates input data and parameters
\item Computes pairwise causality measures
\item Organizes results into causality matrices
\item Provides summary statistics for each causality type
}
}
\section{Related Packages}{

\itemize{
\item \pkg{vars}: Vector autoregression analysis
\item \pkg{tseries}: Time series analysis tools
\item \pkg{forecast}: Time series forecasting methods
}
}

