% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_partition_index}
\alias{glue_create_partition_index}
\title{Creates a specified partition index in an existing table}
\usage{
glue_create_partition_index(CatalogId, DatabaseName, TableName,
  PartitionIndex)
}
\arguments{
\item{CatalogId}{The catalog ID where the table resides.}

\item{DatabaseName}{[required] Specifies the name of a database in which you want to create a partition
index.}

\item{TableName}{[required] Specifies the name of a table in which you want to create a partition
index.}

\item{PartitionIndex}{[required] Specifies a \code{PartitionIndex} structure to create a partition index in an
existing table.}
}
\value{
An empty list.
}
\description{
Creates a specified partition index in an existing table.
}
\section{Request syntax}{
\preformatted{svc$create_partition_index(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  PartitionIndex = list(
    Keys = list(
      "string"
    ),
    IndexName = "string"
  )
)
}
}

\keyword{internal}
