% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_classifiers}
\alias{glue_get_classifiers}
\title{Lists all classifier objects in the Data Catalog}
\usage{
glue_get_classifiers(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{The size of the list to return (optional).}

\item{NextToken}{An optional continuation token.}
}
\value{
A list with the following syntax:\preformatted{list(
  Classifiers = list(
    list(
      GrokClassifier = list(
        Name = "string",
        Classification = "string",
        CreationTime = as.POSIXct(
          "2015-01-01"
        ),
        LastUpdated = as.POSIXct(
          "2015-01-01"
        ),
        Version = 123,
        GrokPattern = "string",
        CustomPatterns = "string"
      ),
      XMLClassifier = list(
        Name = "string",
        Classification = "string",
        CreationTime = as.POSIXct(
          "2015-01-01"
        ),
        LastUpdated = as.POSIXct(
          "2015-01-01"
        ),
        Version = 123,
        RowTag = "string"
      ),
      JsonClassifier = list(
        Name = "string",
        CreationTime = as.POSIXct(
          "2015-01-01"
        ),
        LastUpdated = as.POSIXct(
          "2015-01-01"
        ),
        Version = 123,
        JsonPath = "string"
      ),
      CsvClassifier = list(
        Name = "string",
        CreationTime = as.POSIXct(
          "2015-01-01"
        ),
        LastUpdated = as.POSIXct(
          "2015-01-01"
        ),
        Version = 123,
        Delimiter = "string",
        QuoteSymbol = "string",
        ContainsHeader = "UNKNOWN"|"PRESENT"|"ABSENT",
        Header = list(
          "string"
        ),
        DisableValueTrimming = TRUE|FALSE,
        AllowSingleColumn = TRUE|FALSE
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all classifier objects in the Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$get_classifiers(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
