% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_dataflow_graph}
\alias{glue_get_dataflow_graph}
\title{Transforms a Python script into a directed acyclic graph (DAG)}
\usage{
glue_get_dataflow_graph(PythonScript)
}
\arguments{
\item{PythonScript}{The Python script to transform.}
}
\value{
A list with the following syntax:\preformatted{list(
  DagNodes = list(
    list(
      Id = "string",
      NodeType = "string",
      Args = list(
        list(
          Name = "string",
          Value = "string",
          Param = TRUE|FALSE
        )
      ),
      LineNumber = 123
    )
  ),
  DagEdges = list(
    list(
      Source = "string",
      Target = "string",
      TargetParameter = "string"
    )
  )
)
}
}
\description{
Transforms a Python script into a directed acyclic graph (DAG).
}
\section{Request syntax}{
\preformatted{svc$get_dataflow_graph(
  PythonScript = "string"
)
}
}

\keyword{internal}
