% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_delete_application}
\alias{kinesisanalytics_delete_application}
\title{This documentation is for version 1 of the Amazon Kinesis Data Analytics
API, which only supports SQL applications}
\usage{
kinesisanalytics_delete_application(ApplicationName, CreateTimestamp)
}
\arguments{
\item{ApplicationName}{[required] Name of the Amazon Kinesis Analytics application to delete.}

\item{CreateTimestamp}{[required] You can use the
\code{\link[=kinesisanalytics_describe_application]{describe_application}}
operation to get this value.}
}
\value{
An empty list.
}
\description{
This documentation is for version 1 of the Amazon Kinesis Data Analytics
API, which only supports SQL applications. Version 2 of the API supports
SQL and Java applications. For more information about version 2, see
Amazon Kinesis Data Analytics API V2 Documentation.

Deletes the specified application. Amazon Kinesis Analytics halts
application execution and deletes the application, including any
application artifacts (such as in-application streams, reference table,
and application code).

This operation requires permissions to perform the
\code{kinesisanalytics:DeleteApplication} action.
}
\section{Request syntax}{
\preformatted{svc$delete_application(
  ApplicationName = "string",
  CreateTimestamp = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
