% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticsearchservice_operations.R
\name{elasticsearchservice_dissociate_package}
\alias{elasticsearchservice_dissociate_package}
\title{Dissociates a package from the Amazon ES domain}
\usage{
elasticsearchservice_dissociate_package(PackageID, DomainName)
}
\arguments{
\item{PackageID}{[required] Internal ID of the package that you want to associate with a domain. Use
\code{\link[=elasticsearchservice_describe_packages]{describe_packages}} to find
this value.}

\item{DomainName}{[required] Name of the domain that you want to associate the package with.}
}
\value{
A list with the following syntax:\preformatted{list(
  DomainPackageDetails = list(
    PackageID = "string",
    PackageName = "string",
    PackageType = "TXT-DICTIONARY",
    LastUpdated = as.POSIXct(
      "2015-01-01"
    ),
    DomainName = "string",
    DomainPackageStatus = "ASSOCIATING"|"ASSOCIATION_FAILED"|"ACTIVE"|"DISSOCIATING"|"DISSOCIATION_FAILED",
    PackageVersion = "string",
    ReferencePath = "string",
    ErrorDetails = list(
      ErrorType = "string",
      ErrorMessage = "string"
    )
  )
)
}
}
\description{
Dissociates a package from the Amazon ES domain.
}
\section{Request syntax}{
\preformatted{svc$dissociate_package(
  PackageID = "string",
  DomainName = "string"
)
}
}

\keyword{internal}
