% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_resource_policy}
\alias{glue_get_resource_policy}
\title{Retrieves a specified resource policy}
\usage{
glue_get_resource_policy(ResourceArn)
}
\arguments{
\item{ResourceArn}{The ARN of the AWS Glue resource for the resource policy to be
retrieved. For more information about AWS Glue resource ARNs, see the
\href{https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-common.html#aws-glue-api-regex-aws-glue-arn-id}{AWS Glue ARN string pattern}}
}
\value{
A list with the following syntax:\preformatted{list(
  PolicyInJson = "string",
  PolicyHash = "string",
  CreateTime = as.POSIXct(
    "2015-01-01"
  ),
  UpdateTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Retrieves a specified resource policy.
}
\section{Request syntax}{
\preformatted{svc$get_resource_policy(
  ResourceArn = "string"
)
}
}

\keyword{internal}
