% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_list_scram_secrets}
\alias{kafka_list_scram_secrets}
\title{Returns a list of the Scram Secrets associated with an Amazon MSK
cluster}
\usage{
kafka_list_scram_secrets(ClusterArn, MaxResults, NextToken)
}
\arguments{
\item{ClusterArn}{[required] The arn of the cluster.}

\item{MaxResults}{The maxResults of the query.}

\item{NextToken}{The nextToken of the query.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  SecretArnList = list(
    "string"
  )
)
}
}
\description{
Returns a list of the Scram Secrets associated with an Amazon MSK
cluster.
}
\section{Request syntax}{
\preformatted{svc$list_scram_secrets(
  ClusterArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
