% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_get_qualification_score}
\alias{mturk_get_qualification_score}
\title{The GetQualificationScore operation returns the value of a Worker's
Qualification for a given Qualification type}
\usage{
mturk_get_qualification_score(QualificationTypeId, WorkerId)
}
\arguments{
\item{QualificationTypeId}{[required] The ID of the QualificationType.}

\item{WorkerId}{[required] The ID of the Worker whose Qualification is being updated.}
}
\value{
A list with the following syntax:\preformatted{list(
  Qualification = list(
    QualificationTypeId = "string",
    WorkerId = "string",
    GrantTime = as.POSIXct(
      "2015-01-01"
    ),
    IntegerValue = 123,
    LocaleValue = list(
      Country = "string",
      Subdivision = "string"
    ),
    Status = "Granted"|"Revoked"
  )
)
}
}
\description{
The \code{\link[=mturk_get_qualification_score]{get_qualification_score}} operation
returns the value of a Worker's Qualification for a given Qualification
type.

To get a Worker's Qualification, you must know the Worker's ID. The
Worker's ID is included in the assignment data returned by the
\code{\link[=mturk_list_assignments_for_hit]{list_assignments_for_hit}} operation.

Only the owner of a Qualification type can query the value of a Worker's
Qualification of that type.
}
\section{Request syntax}{
\preformatted{svc$get_qualification_score(
  QualificationTypeId = "string",
  WorkerId = "string"
)
}
}

\keyword{internal}
