% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_theme_permissions}
\alias{quicksight_update_theme_permissions}
\title{Updates the resource permissions for a theme}
\usage{
quicksight_update_theme_permissions(AwsAccountId, ThemeId,
  GrantPermissions, RevokePermissions)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account that contains the theme.}

\item{ThemeId}{[required] The ID for the theme.}

\item{GrantPermissions}{A list of resource permissions to be granted for the theme.}

\item{RevokePermissions}{A list of resource permissions to be revoked from the theme.}
}
\value{
A list with the following syntax:\preformatted{list(
  ThemeId = "string",
  ThemeArn = "string",
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RequestId = "string",
  Status = 123
)
}
}
\description{
Updates the resource permissions for a theme. Permissions apply to the
action to grant or revoke permissions on, for example
\code{"quicksight:DescribeTheme"}.

Theme permissions apply in groupings. Valid groupings include the
following for the three levels of permissions, which are user, owner, or
no permissions:
\itemize{
\item User
\itemize{
\item \code{"quicksight:DescribeTheme"}
\item \code{"quicksight:DescribeThemeAlias"}
\item \code{"quicksight:ListThemeAliases"}
\item \code{"quicksight:ListThemeVersions"}
}
\item Owner
\itemize{
\item \code{"quicksight:DescribeTheme"}
\item \code{"quicksight:DescribeThemeAlias"}
\item \code{"quicksight:ListThemeAliases"}
\item \code{"quicksight:ListThemeVersions"}
\item \code{"quicksight:DeleteTheme"}
\item \code{"quicksight:UpdateTheme"}
\item \code{"quicksight:CreateThemeAlias"}
\item \code{"quicksight:DeleteThemeAlias"}
\item \code{"quicksight:UpdateThemeAlias"}
\item \code{"quicksight:UpdateThemePermissions"}
\item \code{"quicksight:DescribeThemePermissions"}
}
\item To specify no permissions, omit the permissions list.
}
}
\section{Request syntax}{
\preformatted{svc$update_theme_permissions(
  AwsAccountId = "string",
  ThemeId = "string",
  GrantPermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RevokePermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
