% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_delete_delivery_stream}
\alias{firehose_delete_delivery_stream}
\title{Deletes a delivery stream and its data}
\usage{
firehose_delete_delivery_stream(DeliveryStreamName)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}
}
\description{
Deletes a delivery stream and its data.
}
\details{
You can delete a delivery stream only if it is in \code{ACTIVE} or \code{DELETING}
state, and not in the \code{CREATING} state. While the deletion request is in
process, the delivery stream is in the \code{DELETING} state.

To check the state of a delivery stream, use DescribeDeliveryStream.

While the delivery stream is \code{DELETING} state, the service might
continue to accept the records, but it doesn't make any guarantees with
respect to delivering the data. Therefore, as a best practice, you
should first stop any applications that are sending records before
deleting a delivery stream.
}
\section{Request syntax}{
\preformatted{svc$delete_delivery_stream(
  DeliveryStreamName = "string"
)
}
}

\keyword{internal}
