% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_tables}
\alias{glue_get_tables}
\title{Retrieves the definitions of some or all of the tables in a given
Database}
\usage{
glue_get_tables(CatalogId, DatabaseName, Expression, NextToken,
  MaxResults)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the tables reside. If none is supplied,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The database in the catalog whose tables to list. For Hive
compatibility, this name is entirely lowercase.}

\item{Expression}{A regular expression pattern. If present, only those tables whose names
match the pattern are returned.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{MaxResults}{The maximum number of tables to return in a single response.}
}
\description{
Retrieves the definitions of some or all of the tables in a given
\code{Database}.
}
\section{Request syntax}{
\preformatted{svc$get_tables(
  CatalogId = "string",
  DatabaseName = "string",
  Expression = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
