% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_users}
\alias{quicksight_list_users}
\title{Returns a list of all of the Amazon QuickSight users belonging to this
account}
\usage{
quicksight_list_users(AwsAccountId, NextToken, MaxResults, Namespace)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that the user is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{NextToken}{A pagination token that can be used in a subsequent request.}

\item{MaxResults}{The maximum number of results to return from this request.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Returns a list of all of the Amazon QuickSight users belonging to this
account.
}
\details{
The permission resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:user/default/<i>*</i> }.

The response is a list of user objects, containing each user's Amazon
Resource Name (ARN), AWS Identity and Access Management (IAM) role, and
email address.

\strong{CLI Sample:}

\code{aws quicksight list-users --aws-account-id=111122223333 --namespace=default }
}
\section{Request syntax}{
\preformatted{svc$list_users(
  AwsAccountId = "string",
  NextToken = "string",
  MaxResults = 123,
  Namespace = "string"
)
}
}

\keyword{internal}
