# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kinesisanalyticsv2_service.R
NULL

#' Adds an Amazon CloudWatch log stream to monitor application
#' configuration errors
#'
#' Adds an Amazon CloudWatch log stream to monitor application
#' configuration errors.
#'
#' @usage
#' kinesisanalyticsv2_add_application_cloud_watch_logging_option(
#'   ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption)
#'
#' @param ApplicationName &#91;required&#93; The Kinesis Data Analytics application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The version ID of the Kinesis Data Analytics application. You can
#' retrieve the application version ID using DescribeApplication.
#' @param CloudWatchLoggingOption &#91;required&#93; Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN).
#'
#' @section Request syntax:
#' ```
#' svc$add_application_cloud_watch_logging_option(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   CloudWatchLoggingOption = list(
#'     LogStreamARN = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_cloud_watch_logging_option
kinesisanalyticsv2_add_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption) {
  op <- new_operation(
    name = "AddApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOption = CloudWatchLoggingOption)
  output <- .kinesisanalyticsv2$add_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_cloud_watch_logging_option <- kinesisanalyticsv2_add_application_cloud_watch_logging_option

#' Adds a streaming source to your SQL-based Amazon Kinesis Data Analytics
#' application
#'
#' Adds a streaming source to your SQL-based Amazon Kinesis Data Analytics
#' application.
#' 
#' You can add a streaming source when you create an application, or you
#' can use this operation to add a streaming source after you create an
#' application. For more information, see CreateApplication.
#' 
#' Any configuration update, including adding a streaming source using this
#' operation, results in a new version of the application. You can use the
#' DescribeApplication operation to find the current application version.
#'
#' @usage
#' kinesisanalyticsv2_add_application_input(ApplicationName,
#'   CurrentApplicationVersionId, Input)
#'
#' @param ApplicationName &#91;required&#93; The name of your existing application to which you want to add the
#' streaming source.
#' @param CurrentApplicationVersionId &#91;required&#93; The current version of your application. You can use the
#' DescribeApplication operation to find the current application version.
#' @param Input &#91;required&#93; The Input to add.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_input(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   Input = list(
#'     NamePrefix = "string",
#'     InputProcessingConfiguration = list(
#'       InputLambdaProcessor = list(
#'         ResourceARN = "string"
#'       )
#'     ),
#'     KinesisStreamsInput = list(
#'       ResourceARN = "string"
#'     ),
#'     KinesisFirehoseInput = list(
#'       ResourceARN = "string"
#'     ),
#'     InputParallelism = list(
#'       Count = 123
#'     ),
#'     InputSchema = list(
#'       RecordFormat = list(
#'         RecordFormatType = "JSON"|"CSV",
#'         MappingParameters = list(
#'           JSONMappingParameters = list(
#'             RecordRowPath = "string"
#'           ),
#'           CSVMappingParameters = list(
#'             RecordRowDelimiter = "string",
#'             RecordColumnDelimiter = "string"
#'           )
#'         )
#'       ),
#'       RecordEncoding = "string",
#'       RecordColumns = list(
#'         list(
#'           Name = "string",
#'           Mapping = "string",
#'           SqlType = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_input
kinesisanalyticsv2_add_application_input <- function(ApplicationName, CurrentApplicationVersionId, Input) {
  op <- new_operation(
    name = "AddApplicationInput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_input_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Input = Input)
  output <- .kinesisanalyticsv2$add_application_input_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_input <- kinesisanalyticsv2_add_application_input

#' Adds an InputProcessingConfiguration to an SQL-based Kinesis Data
#' Analytics application
#'
#' Adds an InputProcessingConfiguration to an SQL-based Kinesis Data
#' Analytics application. An input processor pre-processes records on the
#' input stream before the application\'s SQL code executes. Currently, the
#' only input processor available is [AWS
#' Lambda](https://aws.amazon.com/documentation/lambda/).
#'
#' @usage
#' kinesisanalyticsv2_add_application_input_processing_configuration(
#'   ApplicationName, CurrentApplicationVersionId, InputId,
#'   InputProcessingConfiguration)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which you want to add the input
#' processing configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application to which you want to add the input
#' processing configuration. You can use the DescribeApplication operation
#' to get the current application version. If the version specified is not
#' the current version, the `ConcurrentModificationException` is returned.
#' @param InputId &#91;required&#93; The ID of the input configuration to add the input processing
#' configuration to. You can get a list of the input IDs for an application
#' using the DescribeApplication operation.
#' @param InputProcessingConfiguration &#91;required&#93; The InputProcessingConfiguration to add to the application.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_input_processing_configuration(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   InputId = "string",
#'   InputProcessingConfiguration = list(
#'     InputLambdaProcessor = list(
#'       ResourceARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_input_processing_configuration
kinesisanalyticsv2_add_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId, InputProcessingConfiguration) {
  op <- new_operation(
    name = "AddApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalyticsv2$add_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_input_processing_configuration <- kinesisanalyticsv2_add_application_input_processing_configuration

#' Adds an external destination to your SQL-based Amazon Kinesis Data
#' Analytics application
#'
#' Adds an external destination to your SQL-based Amazon Kinesis Data
#' Analytics application.
#' 
#' If you want Kinesis Data Analytics to deliver data from an
#' in-application stream within your application to an external destination
#' (such as an Kinesis data stream, a Kinesis Data Firehose delivery
#' stream, or an AWS Lambda function), you add the relevant configuration
#' to your application using this operation. You can configure one or more
#' outputs for your application. Each output configuration maps an
#' in-application stream and an external destination.
#' 
#' You can use one of the output configurations to deliver data from your
#' in-application error stream to an external destination so that you can
#' analyze the errors.
#' 
#' Any configuration update, including adding a streaming source using this
#' operation, results in a new version of the application. You can use the
#' DescribeApplication operation to find the current application version.
#'
#' @usage
#' kinesisanalyticsv2_add_application_output(ApplicationName,
#'   CurrentApplicationVersionId, Output)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which you want to add the output
#' configuration.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application to which you want to add the output
#' configuration. You can use the DescribeApplication operation to get the
#' current application version. If the version specified is not the current
#' version, the `ConcurrentModificationException` is returned.
#' @param Output &#91;required&#93; An array of objects, each describing one output configuration. In the
#' output configuration, you specify the name of an in-application stream,
#' a destination (that is, a Kinesis data stream, a Kinesis Data Firehose
#' delivery stream, or an AWS Lambda function), and record the formation to
#' use when writing to the destination.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_output(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   Output = list(
#'     Name = "string",
#'     KinesisStreamsOutput = list(
#'       ResourceARN = "string"
#'     ),
#'     KinesisFirehoseOutput = list(
#'       ResourceARN = "string"
#'     ),
#'     LambdaOutput = list(
#'       ResourceARN = "string"
#'     ),
#'     DestinationSchema = list(
#'       RecordFormatType = "JSON"|"CSV"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_output
kinesisanalyticsv2_add_application_output <- function(ApplicationName, CurrentApplicationVersionId, Output) {
  op <- new_operation(
    name = "AddApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, Output = Output)
  output <- .kinesisanalyticsv2$add_application_output_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_output <- kinesisanalyticsv2_add_application_output

#' Adds a reference data source to an existing SQL-based Amazon Kinesis
#' Data Analytics application
#'
#' Adds a reference data source to an existing SQL-based Amazon Kinesis
#' Data Analytics application.
#' 
#' Kinesis Data Analytics reads reference data (that is, an Amazon S3
#' object) and creates an in-application table within your application. In
#' the request, you provide the source (S3 bucket name and object key
#' name), name of the in-application table to create, and the necessary
#' mapping information that describes how data in an Amazon S3 object maps
#' to columns in the resulting in-application table.
#'
#' @usage
#' kinesisanalyticsv2_add_application_reference_data_source(
#'   ApplicationName, CurrentApplicationVersionId, ReferenceDataSource)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; The version of the application for which you are adding the reference
#' data source. You can use the DescribeApplication operation to get the
#' current application version. If the version specified is not the current
#' version, the `ConcurrentModificationException` is returned.
#' @param ReferenceDataSource &#91;required&#93; The reference data source can be an object in your Amazon S3 bucket.
#' Kinesis Data Analytics reads the object and copies the data into the
#' in-application table that is created. You provide an S3 bucket, object
#' key name, and the resulting in-application table that is created.
#'
#' @section Request syntax:
#' ```
#' svc$add_application_reference_data_source(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ReferenceDataSource = list(
#'     TableName = "string",
#'     S3ReferenceDataSource = list(
#'       BucketARN = "string",
#'       FileKey = "string"
#'     ),
#'     ReferenceSchema = list(
#'       RecordFormat = list(
#'         RecordFormatType = "JSON"|"CSV",
#'         MappingParameters = list(
#'           JSONMappingParameters = list(
#'             RecordRowPath = "string"
#'           ),
#'           CSVMappingParameters = list(
#'             RecordRowDelimiter = "string",
#'             RecordColumnDelimiter = "string"
#'           )
#'         )
#'       ),
#'       RecordEncoding = "string",
#'       RecordColumns = list(
#'         list(
#'           Name = "string",
#'           Mapping = "string",
#'           SqlType = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_add_application_reference_data_source
kinesisanalyticsv2_add_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceDataSource) {
  op <- new_operation(
    name = "AddApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$add_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceDataSource = ReferenceDataSource)
  output <- .kinesisanalyticsv2$add_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$add_application_reference_data_source <- kinesisanalyticsv2_add_application_reference_data_source

#' Creates an Amazon Kinesis Data Analytics application
#'
#' Creates an Amazon Kinesis Data Analytics application. For information
#' about creating a Kinesis Data Analytics application, see [Creating an
#' Application](https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html).
#'
#' @usage
#' kinesisanalyticsv2_create_application(ApplicationName,
#'   ApplicationDescription, RuntimeEnvironment, ServiceExecutionRole,
#'   ApplicationConfiguration, CloudWatchLoggingOptions, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of your application (for example, `sample-app`).
#' @param ApplicationDescription A summary description of the application.
#' @param RuntimeEnvironment &#91;required&#93; The runtime environment for the application (`SQL-1.0` or `FLINK-1_6`).
#' @param ServiceExecutionRole &#91;required&#93; The IAM role used by the application to access Kinesis data streams,
#' Kinesis Data Firehose delivery streams, Amazon S3 objects, and other
#' external resources.
#' @param ApplicationConfiguration Use this parameter to configure the application.
#' @param CloudWatchLoggingOptions Use this parameter to configure an Amazon CloudWatch log stream to
#' monitor application configuration errors.
#' @param Tags A list of one or more tags to assign to the application. A tag is a
#' key-value pair that identifies an application. Note that the maximum
#' number of application tags includes system tags. The maximum number of
#' user-defined application tags is 50. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *AWS Billing and Cost Management Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ApplicationName = "string",
#'   ApplicationDescription = "string",
#'   RuntimeEnvironment = "SQL-1_0"|"FLINK-1_6",
#'   ServiceExecutionRole = "string",
#'   ApplicationConfiguration = list(
#'     SqlApplicationConfiguration = list(
#'       Inputs = list(
#'         list(
#'           NamePrefix = "string",
#'           InputProcessingConfiguration = list(
#'             InputLambdaProcessor = list(
#'               ResourceARN = "string"
#'             )
#'           ),
#'           KinesisStreamsInput = list(
#'             ResourceARN = "string"
#'           ),
#'           KinesisFirehoseInput = list(
#'             ResourceARN = "string"
#'           ),
#'           InputParallelism = list(
#'             Count = 123
#'           ),
#'           InputSchema = list(
#'             RecordFormat = list(
#'               RecordFormatType = "JSON"|"CSV",
#'               MappingParameters = list(
#'                 JSONMappingParameters = list(
#'                   RecordRowPath = "string"
#'                 ),
#'                 CSVMappingParameters = list(
#'                   RecordRowDelimiter = "string",
#'                   RecordColumnDelimiter = "string"
#'                 )
#'               )
#'             ),
#'             RecordEncoding = "string",
#'             RecordColumns = list(
#'               list(
#'                 Name = "string",
#'                 Mapping = "string",
#'                 SqlType = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       Outputs = list(
#'         list(
#'           Name = "string",
#'           KinesisStreamsOutput = list(
#'             ResourceARN = "string"
#'           ),
#'           KinesisFirehoseOutput = list(
#'             ResourceARN = "string"
#'           ),
#'           LambdaOutput = list(
#'             ResourceARN = "string"
#'           ),
#'           DestinationSchema = list(
#'             RecordFormatType = "JSON"|"CSV"
#'           )
#'         )
#'       ),
#'       ReferenceDataSources = list(
#'         list(
#'           TableName = "string",
#'           S3ReferenceDataSource = list(
#'             BucketARN = "string",
#'             FileKey = "string"
#'           ),
#'           ReferenceSchema = list(
#'             RecordFormat = list(
#'               RecordFormatType = "JSON"|"CSV",
#'               MappingParameters = list(
#'                 JSONMappingParameters = list(
#'                   RecordRowPath = "string"
#'                 ),
#'                 CSVMappingParameters = list(
#'                   RecordRowDelimiter = "string",
#'                   RecordColumnDelimiter = "string"
#'                 )
#'               )
#'             ),
#'             RecordEncoding = "string",
#'             RecordColumns = list(
#'               list(
#'                 Name = "string",
#'                 Mapping = "string",
#'                 SqlType = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     FlinkApplicationConfiguration = list(
#'       CheckpointConfiguration = list(
#'         ConfigurationType = "DEFAULT"|"CUSTOM",
#'         CheckpointingEnabled = TRUE|FALSE,
#'         CheckpointInterval = 123,
#'         MinPauseBetweenCheckpoints = 123
#'       ),
#'       MonitoringConfiguration = list(
#'         ConfigurationType = "DEFAULT"|"CUSTOM",
#'         MetricsLevel = "APPLICATION"|"TASK"|"OPERATOR"|"PARALLELISM",
#'         LogLevel = "INFO"|"WARN"|"ERROR"|"DEBUG"
#'       ),
#'       ParallelismConfiguration = list(
#'         ConfigurationType = "DEFAULT"|"CUSTOM",
#'         Parallelism = 123,
#'         ParallelismPerKPU = 123,
#'         AutoScalingEnabled = TRUE|FALSE
#'       )
#'     ),
#'     EnvironmentProperties = list(
#'       PropertyGroups = list(
#'         list(
#'           PropertyGroupId = "string",
#'           PropertyMap = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     ApplicationCodeConfiguration = list(
#'       CodeContent = list(
#'         TextContent = "string",
#'         ZipFileContent = raw,
#'         S3ContentLocation = list(
#'           BucketARN = "string",
#'           FileKey = "string",
#'           ObjectVersion = "string"
#'         )
#'       ),
#'       CodeContentType = "PLAINTEXT"|"ZIPFILE"
#'     ),
#'     ApplicationSnapshotConfiguration = list(
#'       SnapshotsEnabled = TRUE|FALSE
#'     )
#'   ),
#'   CloudWatchLoggingOptions = list(
#'     list(
#'       LogStreamARN = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_create_application
kinesisanalyticsv2_create_application <- function(ApplicationName, ApplicationDescription = NULL, RuntimeEnvironment, ServiceExecutionRole, ApplicationConfiguration = NULL, CloudWatchLoggingOptions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$create_application_input(ApplicationName = ApplicationName, ApplicationDescription = ApplicationDescription, RuntimeEnvironment = RuntimeEnvironment, ServiceExecutionRole = ServiceExecutionRole, ApplicationConfiguration = ApplicationConfiguration, CloudWatchLoggingOptions = CloudWatchLoggingOptions, Tags = Tags)
  output <- .kinesisanalyticsv2$create_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$create_application <- kinesisanalyticsv2_create_application

#' Creates a snapshot of the application's state data
#'
#' Creates a snapshot of the application\'s state data.
#'
#' @usage
#' kinesisanalyticsv2_create_application_snapshot(ApplicationName,
#'   SnapshotName)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application
#' @param SnapshotName &#91;required&#93; An identifier for the application snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_application_snapshot(
#'   ApplicationName = "string",
#'   SnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_create_application_snapshot
kinesisanalyticsv2_create_application_snapshot <- function(ApplicationName, SnapshotName) {
  op <- new_operation(
    name = "CreateApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$create_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName)
  output <- .kinesisanalyticsv2$create_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$create_application_snapshot <- kinesisanalyticsv2_create_application_snapshot

#' Deletes the specified application
#'
#' Deletes the specified application. Kinesis Data Analytics halts
#' application execution and deletes the application.
#'
#' @usage
#' kinesisanalyticsv2_delete_application(ApplicationName, CreateTimestamp)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete.
#' @param CreateTimestamp &#91;required&#93; Use the `DescribeApplication` operation to get this value.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ApplicationName = "string",
#'   CreateTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application
kinesisanalyticsv2_delete_application <- function(ApplicationName, CreateTimestamp) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_input(ApplicationName = ApplicationName, CreateTimestamp = CreateTimestamp)
  output <- .kinesisanalyticsv2$delete_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application <- kinesisanalyticsv2_delete_application

#' Deletes an Amazon CloudWatch log stream from an Amazon Kinesis Data
#' Analytics application
#'
#' Deletes an Amazon CloudWatch log stream from an Amazon Kinesis Data
#' Analytics application.
#'
#' @usage
#' kinesisanalyticsv2_delete_application_cloud_watch_logging_option(
#'   ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOptionId)
#'
#' @param ApplicationName &#91;required&#93; The application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The version ID of the application. You can retrieve the application
#' version ID using DescribeApplication.
#' @param CloudWatchLoggingOptionId &#91;required&#93; The `CloudWatchLoggingOptionId` of the Amazon CloudWatch logging option
#' to delete. You can get the `CloudWatchLoggingOptionId` by using the
#' DescribeApplication operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_cloud_watch_logging_option(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   CloudWatchLoggingOptionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_cloud_watch_logging_option
kinesisanalyticsv2_delete_application_cloud_watch_logging_option <- function(ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOptionId) {
  op <- new_operation(
    name = "DeleteApplicationCloudWatchLoggingOption",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_cloud_watch_logging_option_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, CloudWatchLoggingOptionId = CloudWatchLoggingOptionId)
  output <- .kinesisanalyticsv2$delete_application_cloud_watch_logging_option_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_cloud_watch_logging_option <- kinesisanalyticsv2_delete_application_cloud_watch_logging_option

#' Deletes an InputProcessingConfiguration from an input
#'
#' Deletes an InputProcessingConfiguration from an input.
#'
#' @usage
#' kinesisanalyticsv2_delete_application_input_processing_configuration(
#'   ApplicationName, CurrentApplicationVersionId, InputId)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param CurrentApplicationVersionId &#91;required&#93; The application version. You can use the DescribeApplication operation
#' to get the current application version. If the version specified is not
#' the current version, the `ConcurrentModificationException` is returned.
#' @param InputId &#91;required&#93; The ID of the input configuration from which to delete the input
#' processing configuration. You can get a list of the input IDs for an
#' application by using the DescribeApplication operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_input_processing_configuration(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   InputId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_input_processing_configuration
kinesisanalyticsv2_delete_application_input_processing_configuration <- function(ApplicationName, CurrentApplicationVersionId, InputId) {
  op <- new_operation(
    name = "DeleteApplicationInputProcessingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_input_processing_configuration_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, InputId = InputId)
  output <- .kinesisanalyticsv2$delete_application_input_processing_configuration_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_input_processing_configuration <- kinesisanalyticsv2_delete_application_input_processing_configuration

#' Deletes the output destination configuration from your SQL-based Amazon
#' Kinesis Data Analytics application's configuration
#'
#' Deletes the output destination configuration from your SQL-based Amazon
#' Kinesis Data Analytics application\'s configuration. Kinesis Data
#' Analytics will no longer write data from the corresponding
#' in-application stream to the external output destination.
#'
#' @usage
#' kinesisanalyticsv2_delete_application_output(ApplicationName,
#'   CurrentApplicationVersionId, OutputId)
#'
#' @param ApplicationName &#91;required&#93; The application name.
#' @param CurrentApplicationVersionId &#91;required&#93; The application version. You can use the DescribeApplication operation
#' to get the current application version. If the version specified is not
#' the current version, the `ConcurrentModificationException` is returned.
#' @param OutputId &#91;required&#93; The ID of the configuration to delete. Each output configuration that is
#' added to the application (either when the application is created or
#' later) using the AddApplicationOutput operation has a unique ID. You
#' need to provide the ID to uniquely identify the output configuration
#' that you want to delete from the application configuration. You can use
#' the DescribeApplication operation to get the specific `OutputId`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_output(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   OutputId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_output
kinesisanalyticsv2_delete_application_output <- function(ApplicationName, CurrentApplicationVersionId, OutputId) {
  op <- new_operation(
    name = "DeleteApplicationOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_output_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, OutputId = OutputId)
  output <- .kinesisanalyticsv2$delete_application_output_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_output <- kinesisanalyticsv2_delete_application_output

#' Deletes a reference data source configuration from the specified
#' SQL-based Amazon Kinesis Data Analytics application's configuration
#'
#' Deletes a reference data source configuration from the specified
#' SQL-based Amazon Kinesis Data Analytics application\'s configuration.
#' 
#' If the application is running, Kinesis Data Analytics immediately
#' removes the in-application table that you created using the
#' AddApplicationReferenceDataSource operation.
#'
#' @usage
#' kinesisanalyticsv2_delete_application_reference_data_source(
#'   ApplicationName, CurrentApplicationVersionId, ReferenceId)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param CurrentApplicationVersionId &#91;required&#93; The current application version. You can use the DescribeApplication
#' operation to get the current application version. If the version
#' specified is not the current version, the
#' `ConcurrentModificationException` is returned.
#' @param ReferenceId &#91;required&#93; The ID of the reference data source. When you add a reference data
#' source to your application using the AddApplicationReferenceDataSource,
#' Kinesis Data Analytics assigns an ID. You can use the
#' DescribeApplication operation to get the reference ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_reference_data_source(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ReferenceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_reference_data_source
kinesisanalyticsv2_delete_application_reference_data_source <- function(ApplicationName, CurrentApplicationVersionId, ReferenceId) {
  op <- new_operation(
    name = "DeleteApplicationReferenceDataSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_reference_data_source_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ReferenceId = ReferenceId)
  output <- .kinesisanalyticsv2$delete_application_reference_data_source_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_reference_data_source <- kinesisanalyticsv2_delete_application_reference_data_source

#' Deletes a snapshot of application state
#'
#' Deletes a snapshot of application state.
#'
#' @usage
#' kinesisanalyticsv2_delete_application_snapshot(ApplicationName,
#'   SnapshotName, SnapshotCreationTimestamp)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param SnapshotName &#91;required&#93; The identifier for the snapshot delete.
#' @param SnapshotCreationTimestamp &#91;required&#93; The creation timestamp of the application snapshot to delete. You can
#' retrieve this value using or .
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_snapshot(
#'   ApplicationName = "string",
#'   SnapshotName = "string",
#'   SnapshotCreationTimestamp = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_delete_application_snapshot
kinesisanalyticsv2_delete_application_snapshot <- function(ApplicationName, SnapshotName, SnapshotCreationTimestamp) {
  op <- new_operation(
    name = "DeleteApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$delete_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName, SnapshotCreationTimestamp = SnapshotCreationTimestamp)
  output <- .kinesisanalyticsv2$delete_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$delete_application_snapshot <- kinesisanalyticsv2_delete_application_snapshot

#' Returns information about a specific Amazon Kinesis Data Analytics
#' application
#'
#' Returns information about a specific Amazon Kinesis Data Analytics
#' application.
#' 
#' If you want to retrieve a list of all applications in your account, use
#' the ListApplications operation.
#'
#' @usage
#' kinesisanalyticsv2_describe_application(ApplicationName,
#'   IncludeAdditionalDetails)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param IncludeAdditionalDetails Displays verbose information about a Kinesis Data Analytics application,
#' including the application\'s job plan.
#'
#' @section Request syntax:
#' ```
#' svc$describe_application(
#'   ApplicationName = "string",
#'   IncludeAdditionalDetails = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_describe_application
kinesisanalyticsv2_describe_application <- function(ApplicationName, IncludeAdditionalDetails = NULL) {
  op <- new_operation(
    name = "DescribeApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$describe_application_input(ApplicationName = ApplicationName, IncludeAdditionalDetails = IncludeAdditionalDetails)
  output <- .kinesisanalyticsv2$describe_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$describe_application <- kinesisanalyticsv2_describe_application

#' Returns information about a snapshot of application state data
#'
#' Returns information about a snapshot of application state data.
#'
#' @usage
#' kinesisanalyticsv2_describe_application_snapshot(ApplicationName,
#'   SnapshotName)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param SnapshotName &#91;required&#93; The identifier of an application snapshot. You can retrieve this value
#' using .
#'
#' @section Request syntax:
#' ```
#' svc$describe_application_snapshot(
#'   ApplicationName = "string",
#'   SnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_describe_application_snapshot
kinesisanalyticsv2_describe_application_snapshot <- function(ApplicationName, SnapshotName) {
  op <- new_operation(
    name = "DescribeApplicationSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$describe_application_snapshot_input(ApplicationName = ApplicationName, SnapshotName = SnapshotName)
  output <- .kinesisanalyticsv2$describe_application_snapshot_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$describe_application_snapshot <- kinesisanalyticsv2_describe_application_snapshot

#' Infers a schema for an SQL-based Amazon Kinesis Data Analytics
#' application by evaluating sample records on the specified streaming
#' source (Kinesis data stream or Kinesis Data Firehose delivery stream) or
#' Amazon S3 object
#'
#' Infers a schema for an SQL-based Amazon Kinesis Data Analytics
#' application by evaluating sample records on the specified streaming
#' source (Kinesis data stream or Kinesis Data Firehose delivery stream) or
#' Amazon S3 object. In the response, the operation returns the inferred
#' schema and also the sample records that the operation used to infer the
#' schema.
#' 
#' You can use the inferred schema when configuring a streaming source for
#' your application. When you create an application using the Kinesis Data
#' Analytics console, the console uses this operation to infer a schema and
#' show it in the console user interface.
#'
#' @usage
#' kinesisanalyticsv2_discover_input_schema(ResourceARN,
#'   ServiceExecutionRole, InputStartingPositionConfiguration,
#'   S3Configuration, InputProcessingConfiguration)
#'
#' @param ResourceARN The Amazon Resource Name (ARN) of the streaming source.
#' @param ServiceExecutionRole &#91;required&#93; The ARN of the role that is used to access the streaming source.
#' @param InputStartingPositionConfiguration The point at which you want Kinesis Data Analytics to start reading
#' records from the specified streaming source discovery purposes.
#' @param S3Configuration Specify this parameter to discover a schema from data in an Amazon S3
#' object.
#' @param InputProcessingConfiguration The InputProcessingConfiguration to use to preprocess the records before
#' discovering the schema of the records.
#'
#' @section Request syntax:
#' ```
#' svc$discover_input_schema(
#'   ResourceARN = "string",
#'   ServiceExecutionRole = "string",
#'   InputStartingPositionConfiguration = list(
#'     InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
#'   ),
#'   S3Configuration = list(
#'     BucketARN = "string",
#'     FileKey = "string"
#'   ),
#'   InputProcessingConfiguration = list(
#'     InputLambdaProcessor = list(
#'       ResourceARN = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_discover_input_schema
kinesisanalyticsv2_discover_input_schema <- function(ResourceARN = NULL, ServiceExecutionRole, InputStartingPositionConfiguration = NULL, S3Configuration = NULL, InputProcessingConfiguration = NULL) {
  op <- new_operation(
    name = "DiscoverInputSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$discover_input_schema_input(ResourceARN = ResourceARN, ServiceExecutionRole = ServiceExecutionRole, InputStartingPositionConfiguration = InputStartingPositionConfiguration, S3Configuration = S3Configuration, InputProcessingConfiguration = InputProcessingConfiguration)
  output <- .kinesisanalyticsv2$discover_input_schema_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$discover_input_schema <- kinesisanalyticsv2_discover_input_schema

#' Lists information about the current application snapshots
#'
#' Lists information about the current application snapshots.
#'
#' @usage
#' kinesisanalyticsv2_list_application_snapshots(ApplicationName, Limit,
#'   NextToken)
#'
#' @param ApplicationName &#91;required&#93; The name of an existing application.
#' @param Limit The maximum number of application snapshots to list.
#' @param NextToken Use this parameter if you receive a `NextToken` response in a previous
#' request that indicates that there is more output available. Set it to
#' the value of the previous call\'s `NextToken` response to indicate where
#' the output should continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_application_snapshots(
#'   ApplicationName = "string",
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_application_snapshots
kinesisanalyticsv2_list_application_snapshots <- function(ApplicationName, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_application_snapshots_input(ApplicationName = ApplicationName, Limit = Limit, NextToken = NextToken)
  output <- .kinesisanalyticsv2$list_application_snapshots_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_application_snapshots <- kinesisanalyticsv2_list_application_snapshots

#' Returns a list of Amazon Kinesis Data Analytics applications in your
#' account
#'
#' Returns a list of Amazon Kinesis Data Analytics applications in your
#' account. For each application, the response includes the application
#' name, Amazon Resource Name (ARN), and status.
#' 
#' If you want detailed information about a specific application, use
#' DescribeApplication.
#'
#' @usage
#' kinesisanalyticsv2_list_applications(Limit, NextToken)
#'
#' @param Limit The maximum number of applications to list.
#' @param NextToken If a previous command returned a pagination token, pass it into this
#' value to retrieve the next set of results. For more information about
#' pagination, see [Using the AWS Command Line Interface\'s Pagination
#' Options](https://docs.aws.amazon.com/cli/latest/userguide/pagination.html).
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   Limit = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_applications
kinesisanalyticsv2_list_applications <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_applications_input(Limit = Limit, NextToken = NextToken)
  output <- .kinesisanalyticsv2$list_applications_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_applications <- kinesisanalyticsv2_list_applications

#' Retrieves the list of key-value tags assigned to the application
#'
#' Retrieves the list of key-value tags assigned to the application.
#'
#' @usage
#' kinesisanalyticsv2_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application for which to retrieve tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_list_tags_for_resource
kinesisanalyticsv2_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .kinesisanalyticsv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$list_tags_for_resource <- kinesisanalyticsv2_list_tags_for_resource

#' Starts the specified Amazon Kinesis Data Analytics application
#'
#' Starts the specified Amazon Kinesis Data Analytics application. After
#' creating an application, you must exclusively call this operation to
#' start your application.
#'
#' @usage
#' kinesisanalyticsv2_start_application(ApplicationName, RunConfiguration)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param RunConfiguration &#91;required&#93; Identifies the run configuration (start parameters) of a Kinesis Data
#' Analytics application.
#'
#' @section Request syntax:
#' ```
#' svc$start_application(
#'   ApplicationName = "string",
#'   RunConfiguration = list(
#'     SqlRunConfigurations = list(
#'       list(
#'         InputId = "string",
#'         InputStartingPositionConfiguration = list(
#'           InputStartingPosition = "NOW"|"TRIM_HORIZON"|"LAST_STOPPED_POINT"
#'         )
#'       )
#'     ),
#'     ApplicationRestoreConfiguration = list(
#'       ApplicationRestoreType = "SKIP_RESTORE_FROM_SNAPSHOT"|"RESTORE_FROM_LATEST_SNAPSHOT"|"RESTORE_FROM_CUSTOM_SNAPSHOT",
#'       SnapshotName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_start_application
kinesisanalyticsv2_start_application <- function(ApplicationName, RunConfiguration) {
  op <- new_operation(
    name = "StartApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$start_application_input(ApplicationName = ApplicationName, RunConfiguration = RunConfiguration)
  output <- .kinesisanalyticsv2$start_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$start_application <- kinesisanalyticsv2_start_application

#' Stops the application from processing data
#'
#' Stops the application from processing data. You can stop an application
#' only if it is in the running state. You can use the DescribeApplication
#' operation to find the application state.
#'
#' @usage
#' kinesisanalyticsv2_stop_application(ApplicationName)
#'
#' @param ApplicationName &#91;required&#93; The name of the running application to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_application(
#'   ApplicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_stop_application
kinesisanalyticsv2_stop_application <- function(ApplicationName) {
  op <- new_operation(
    name = "StopApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$stop_application_input(ApplicationName = ApplicationName)
  output <- .kinesisanalyticsv2$stop_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$stop_application <- kinesisanalyticsv2_stop_application

#' Adds one or more key-value tags to a Kinesis Analytics application
#'
#' Adds one or more key-value tags to a Kinesis Analytics application. Note
#' that the maximum number of application tags includes system tags. The
#' maximum number of user-defined application tags is 50.
#'
#' @usage
#' kinesisanalyticsv2_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the application to assign the tags.
#' @param Tags &#91;required&#93; The key-value tags to assign to the application.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_tag_resource
kinesisanalyticsv2_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .kinesisanalyticsv2$tag_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$tag_resource <- kinesisanalyticsv2_tag_resource

#' Removes one or more tags from a Kinesis Analytics application
#'
#' Removes one or more tags from a Kinesis Analytics application.
#'
#' @usage
#' kinesisanalyticsv2_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Kinesis Analytics application from which to remove the
#' tags.
#' @param TagKeys &#91;required&#93; A list of keys of tags to remove from the specified application.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_untag_resource
kinesisanalyticsv2_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .kinesisanalyticsv2$untag_resource_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$untag_resource <- kinesisanalyticsv2_untag_resource

#' Updates an existing Amazon Kinesis Data Analytics application
#'
#' Updates an existing Amazon Kinesis Data Analytics application. Using
#' this operation, you can update application code, input configuration,
#' and output configuration.
#' 
#' Kinesis Data Analytics updates the `ApplicationVersionId` each time you
#' update your application.
#'
#' @usage
#' kinesisanalyticsv2_update_application(ApplicationName,
#'   CurrentApplicationVersionId, ApplicationConfigurationUpdate,
#'   ServiceExecutionRoleUpdate, RunConfigurationUpdate,
#'   CloudWatchLoggingOptionUpdates)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to update.
#' @param CurrentApplicationVersionId &#91;required&#93; The current application version ID. You can retrieve the application
#' version ID using DescribeApplication.
#' @param ApplicationConfigurationUpdate Describes application configuration updates.
#' @param ServiceExecutionRoleUpdate Describes updates to the service execution role.
#' @param RunConfigurationUpdate Describes updates to the application\'s starting parameters.
#' @param CloudWatchLoggingOptionUpdates Describes application Amazon CloudWatch logging option updates. You can
#' only update existing CloudWatch logging options with this action. To add
#' a new CloudWatch logging option, use
#' AddApplicationCloudWatchLoggingOption.
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ApplicationName = "string",
#'   CurrentApplicationVersionId = 123,
#'   ApplicationConfigurationUpdate = list(
#'     SqlApplicationConfigurationUpdate = list(
#'       InputUpdates = list(
#'         list(
#'           InputId = "string",
#'           NamePrefixUpdate = "string",
#'           InputProcessingConfigurationUpdate = list(
#'             InputLambdaProcessorUpdate = list(
#'               ResourceARNUpdate = "string"
#'             )
#'           ),
#'           KinesisStreamsInputUpdate = list(
#'             ResourceARNUpdate = "string"
#'           ),
#'           KinesisFirehoseInputUpdate = list(
#'             ResourceARNUpdate = "string"
#'           ),
#'           InputSchemaUpdate = list(
#'             RecordFormatUpdate = list(
#'               RecordFormatType = "JSON"|"CSV",
#'               MappingParameters = list(
#'                 JSONMappingParameters = list(
#'                   RecordRowPath = "string"
#'                 ),
#'                 CSVMappingParameters = list(
#'                   RecordRowDelimiter = "string",
#'                   RecordColumnDelimiter = "string"
#'                 )
#'               )
#'             ),
#'             RecordEncodingUpdate = "string",
#'             RecordColumnUpdates = list(
#'               list(
#'                 Name = "string",
#'                 Mapping = "string",
#'                 SqlType = "string"
#'               )
#'             )
#'           ),
#'           InputParallelismUpdate = list(
#'             CountUpdate = 123
#'           )
#'         )
#'       ),
#'       OutputUpdates = list(
#'         list(
#'           OutputId = "string",
#'           NameUpdate = "string",
#'           KinesisStreamsOutputUpdate = list(
#'             ResourceARNUpdate = "string"
#'           ),
#'           KinesisFirehoseOutputUpdate = list(
#'             ResourceARNUpdate = "string"
#'           ),
#'           LambdaOutputUpdate = list(
#'             ResourceARNUpdate = "string"
#'           ),
#'           DestinationSchemaUpdate = list(
#'             RecordFormatType = "JSON"|"CSV"
#'           )
#'         )
#'       ),
#'       ReferenceDataSourceUpdates = list(
#'         list(
#'           ReferenceId = "string",
#'           TableNameUpdate = "string",
#'           S3ReferenceDataSourceUpdate = list(
#'             BucketARNUpdate = "string",
#'             FileKeyUpdate = "string"
#'           ),
#'           ReferenceSchemaUpdate = list(
#'             RecordFormat = list(
#'               RecordFormatType = "JSON"|"CSV",
#'               MappingParameters = list(
#'                 JSONMappingParameters = list(
#'                   RecordRowPath = "string"
#'                 ),
#'                 CSVMappingParameters = list(
#'                   RecordRowDelimiter = "string",
#'                   RecordColumnDelimiter = "string"
#'                 )
#'               )
#'             ),
#'             RecordEncoding = "string",
#'             RecordColumns = list(
#'               list(
#'                 Name = "string",
#'                 Mapping = "string",
#'                 SqlType = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     ApplicationCodeConfigurationUpdate = list(
#'       CodeContentTypeUpdate = "PLAINTEXT"|"ZIPFILE",
#'       CodeContentUpdate = list(
#'         TextContentUpdate = "string",
#'         ZipFileContentUpdate = raw,
#'         S3ContentLocationUpdate = list(
#'           BucketARNUpdate = "string",
#'           FileKeyUpdate = "string",
#'           ObjectVersionUpdate = "string"
#'         )
#'       )
#'     ),
#'     FlinkApplicationConfigurationUpdate = list(
#'       CheckpointConfigurationUpdate = list(
#'         ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
#'         CheckpointingEnabledUpdate = TRUE|FALSE,
#'         CheckpointIntervalUpdate = 123,
#'         MinPauseBetweenCheckpointsUpdate = 123
#'       ),
#'       MonitoringConfigurationUpdate = list(
#'         ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
#'         MetricsLevelUpdate = "APPLICATION"|"TASK"|"OPERATOR"|"PARALLELISM",
#'         LogLevelUpdate = "INFO"|"WARN"|"ERROR"|"DEBUG"
#'       ),
#'       ParallelismConfigurationUpdate = list(
#'         ConfigurationTypeUpdate = "DEFAULT"|"CUSTOM",
#'         ParallelismUpdate = 123,
#'         ParallelismPerKPUUpdate = 123,
#'         AutoScalingEnabledUpdate = TRUE|FALSE
#'       )
#'     ),
#'     EnvironmentPropertyUpdates = list(
#'       PropertyGroups = list(
#'         list(
#'           PropertyGroupId = "string",
#'           PropertyMap = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     ApplicationSnapshotConfigurationUpdate = list(
#'       SnapshotsEnabledUpdate = TRUE|FALSE
#'     )
#'   ),
#'   ServiceExecutionRoleUpdate = "string",
#'   RunConfigurationUpdate = list(
#'     ApplicationRestoreConfiguration = list(
#'       ApplicationRestoreType = "SKIP_RESTORE_FROM_SNAPSHOT"|"RESTORE_FROM_LATEST_SNAPSHOT"|"RESTORE_FROM_CUSTOM_SNAPSHOT",
#'       SnapshotName = "string"
#'     )
#'   ),
#'   CloudWatchLoggingOptionUpdates = list(
#'     list(
#'       CloudWatchLoggingOptionId = "string",
#'       LogStreamARNUpdate = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kinesisanalyticsv2_update_application
kinesisanalyticsv2_update_application <- function(ApplicationName, CurrentApplicationVersionId, ApplicationConfigurationUpdate = NULL, ServiceExecutionRoleUpdate = NULL, RunConfigurationUpdate = NULL, CloudWatchLoggingOptionUpdates = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kinesisanalyticsv2$update_application_input(ApplicationName = ApplicationName, CurrentApplicationVersionId = CurrentApplicationVersionId, ApplicationConfigurationUpdate = ApplicationConfigurationUpdate, ServiceExecutionRoleUpdate = ServiceExecutionRoleUpdate, RunConfigurationUpdate = RunConfigurationUpdate, CloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdates)
  output <- .kinesisanalyticsv2$update_application_output()
  config <- get_config()
  svc <- .kinesisanalyticsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kinesisanalyticsv2$operations$update_application <- kinesisanalyticsv2_update_application
