% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_dev_endpoint}
\alias{glue_update_dev_endpoint}
\title{Updates a specified DevEndpoint}
\usage{
glue_update_dev_endpoint(EndpointName, PublicKey, AddPublicKeys,
  DeletePublicKeys, CustomLibraries, UpdateEtlLibraries, DeleteArguments,
  AddArguments)
}
\arguments{
\item{EndpointName}{[required] The name of the DevEndpoint to be updated.}

\item{PublicKey}{The public key for the DevEndpoint to use.}

\item{AddPublicKeys}{The list of public keys for the DevEndpoint to use.}

\item{DeletePublicKeys}{The list of public keys to be deleted from the DevEndpoint.}

\item{CustomLibraries}{Custom Python or Java libraries to be loaded in the DevEndpoint.}

\item{UpdateEtlLibraries}{True if the list of custom libraries to be loaded in the development
endpoint needs to be updated, or False otherwise.}

\item{DeleteArguments}{The list of argument keys to be deleted from the map of arguments used
to configure the DevEndpoint.}

\item{AddArguments}{The map of arguments to add the map of arguments used to configure the
DevEndpoint.}
}
\description{
Updates a specified DevEndpoint.
}
\section{Request syntax}{
\preformatted{svc$update_dev_endpoint(
  EndpointName = "string",
  PublicKey = "string",
  AddPublicKeys = list(
    "string"
  ),
  DeletePublicKeys = list(
    "string"
  ),
  CustomLibraries = list(
    ExtraPythonLibsS3Path = "string",
    ExtraJarsS3Path = "string"
  ),
  UpdateEtlLibraries = TRUE|FALSE,
  DeleteArguments = list(
    "string"
  ),
  AddArguments = list(
    "string"
  )
)
}
}

\keyword{internal}
