% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_partition}
\alias{glue_create_partition}
\title{Creates a new partition}
\usage{
glue_create_partition(CatalogId, DatabaseName, TableName,
  PartitionInput)
}
\arguments{
\item{CatalogId}{The AWS account ID of the catalog in which the partition is to be
created.}

\item{DatabaseName}{[required] The name of the metadata database in which the partition is to be
created.}

\item{TableName}{[required] The name of the metadata table in which the partition is to be created.}

\item{PartitionInput}{[required] A \code{PartitionInput} structure defining the partition to be created.}
}
\description{
Creates a new partition.
}
\section{Request syntax}{
\preformatted{svc$create_partition(
  CatalogId = "string",
  DatabaseName = "string",
  TableName = "string",
  PartitionInput = list(
    Values = list(
      "string"
    ),
    LastAccessTime = as.POSIXct(
      "2015-01-01"
    ),
    StorageDescriptor = list(
      Columns = list(
        list(
          Name = "string",
          Type = "string",
          Comment = "string",
          Parameters = list(
            "string"
          )
        )
      ),
      Location = "string",
      InputFormat = "string",
      OutputFormat = "string",
      Compressed = TRUE|FALSE,
      NumberOfBuckets = 123,
      SerdeInfo = list(
        Name = "string",
        SerializationLibrary = "string",
        Parameters = list(
          "string"
        )
      ),
      BucketColumns = list(
        "string"
      ),
      SortColumns = list(
        list(
          Column = "string",
          SortOrder = 123
        )
      ),
      Parameters = list(
        "string"
      ),
      SkewedInfo = list(
        SkewedColumnNames = list(
          "string"
        ),
        SkewedColumnValues = list(
          "string"
        ),
        SkewedColumnValueLocationMaps = list(
          "string"
        )
      ),
      StoredAsSubDirectories = TRUE|FALSE
    ),
    Parameters = list(
      "string"
    ),
    LastAnalyzedTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}

\keyword{internal}
