% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_plan}
\alias{glue_get_plan}
\title{Gets code to perform a specified mapping}
\usage{
glue_get_plan(Mapping, Source, Sinks, Location, Language)
}
\arguments{
\item{Mapping}{[required] The list of mappings from a source table to target tables.}

\item{Source}{[required] The source table.}

\item{Sinks}{The target tables.}

\item{Location}{The parameters for the mapping.}

\item{Language}{The programming language of the code to perform the mapping.}
}
\description{
Gets code to perform a specified mapping.
}
\section{Request syntax}{
\preformatted{svc$get_plan(
  Mapping = list(
    list(
      SourceTable = "string",
      SourcePath = "string",
      SourceType = "string",
      TargetTable = "string",
      TargetPath = "string",
      TargetType = "string"
    )
  ),
  Source = list(
    DatabaseName = "string",
    TableName = "string"
  ),
  Sinks = list(
    list(
      DatabaseName = "string",
      TableName = "string"
    )
  ),
  Location = list(
    Jdbc = list(
      list(
        Name = "string",
        Value = "string",
        Param = TRUE|FALSE
      )
    ),
    S3 = list(
      list(
        Name = "string",
        Value = "string",
        Param = TRUE|FALSE
      )
    ),
    DynamoDB = list(
      list(
        Name = "string",
        Value = "string",
        Param = TRUE|FALSE
      )
    )
  ),
  Language = "PYTHON"|"SCALA"
)
}
}

\keyword{internal}
