% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_dashboard}
\alias{quicksight_create_dashboard}
\title{Creates a dashboard from a template}
\usage{
quicksight_create_dashboard(AwsAccountId, DashboardId, Name, Parameters,
  Permissions, SourceEntity, Tags, VersionDescription,
  DashboardPublishOptions)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the AWS account where you want to create the dashboard.}

\item{DashboardId}{[required] The ID for the dashboard, also added to the IAM policy.}

\item{Name}{[required] The display name of the dashboard.}

\item{Parameters}{A structure that contains the parameters of the dashboard. These are
parameter overrides for a dashboard. A dashboard can have any type of
parameters, and some parameters might accept multiple values. You can
use the dashboard permissions structure described following to override
two string parameters that accept multiple values.}

\item{Permissions}{A structure that contains the permissions of the dashboard. You can use
this structure for granting permissions with principal and action
information.}

\item{SourceEntity}{[required] The source entity from which the dashboard is created. The source entity
accepts the Amazon Resource Name (ARN) of the source template or
analysis and also references the replacement datasets for the
placeholders set when creating the template. The replacement datasets
need to follow the same schema as the datasets for which placeholders
were created when creating the template.

If you are creating a dashboard from a source entity in a different AWS
account, use the ARN of the source template.}

\item{Tags}{Contains a map of the key-value pairs for the resource tag or tags
assigned to the dashboard.}

\item{VersionDescription}{A description for the first version of the dashboard being created.}

\item{DashboardPublishOptions}{Options for publishing the dashboard when you create it:
\itemize{
\item \code{AvailabilityStatus} for \code{AdHocFilteringOption} - This status can be
either \code{ENABLED} or \code{DISABLED}. When this is set to \code{DISABLED},
QuickSight disables the left filter pane on the published dashboard,
which can be used for ad hoc (one-time) filtering. This option is
\code{ENABLED} by default.
\item \code{AvailabilityStatus} for \code{ExportToCSVOption} - This status can be
either \code{ENABLED} or \code{DISABLED}. The visual option to export data to
.csv format isn\'t enabled when this is set to \code{DISABLED}. This
option is \code{ENABLED} by default.
\item \code{VisibilityState} for \code{SheetControlsOption} - This visibility state
can be either \code{COLLAPSED} or \code{EXPANDED}. The sheet controls pane is
collapsed by default when set to true. This option is \code{COLLAPSED} by
default.
}}
}
\description{
Creates a dashboard from a template. To first create a template, see the
CreateTemplate API operation.
}
\details{
A dashboard is an entity in QuickSight that identifies QuickSight
reports, created from analyses. You can share QuickSight dashboards.
With the right permissions, you can create scheduled email reports from
them. The \code{CreateDashboard}, \code{DescribeDashboard}, and
\code{ListDashboardsByUser} API operations act on the dashboard entity. If
you have the correct permissions, you can create a dashboard from a
template that exists in a different AWS account.
}
\section{Request syntax}{
\preformatted{svc$create_dashboard(
  AwsAccountId = "string",
  DashboardId = "string",
  Name = "string",
  Parameters = list(
    StringParameters = list(
      list(
        Name = "string",
        Values = list(
          "string"
        )
      )
    ),
    IntegerParameters = list(
      list(
        Name = "string",
        Values = list(
          123
        )
      )
    ),
    DecimalParameters = list(
      list(
        Name = "string",
        Values = list(
          123.0
        )
      )
    ),
    DateTimeParameters = list(
      list(
        Name = "string",
        Values = list(
          as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  Permissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  SourceEntity = list(
    SourceTemplate = list(
      DataSetReferences = list(
        list(
          DataSetPlaceholder = "string",
          DataSetArn = "string"
        )
      ),
      Arn = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  VersionDescription = "string",
  DashboardPublishOptions = list(
    AdHocFilteringOption = list(
      AvailabilityStatus = "ENABLED"|"DISABLED"
    ),
    ExportToCSVOption = list(
      AvailabilityStatus = "ENABLED"|"DISABLED"
    ),
    SheetControlsOption = list(
      VisibilityState = "EXPANDED"|"COLLAPSED"
    )
  )
)
}
}

\keyword{internal}
