% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_suggesters}
\alias{cloudsearch_describe_suggesters}
\title{Gets the suggesters configured for a domain}
\usage{
cloudsearch_describe_suggesters(DomainName, SuggesterNames, Deployed)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{SuggesterNames}{The suggesters you want to describe.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets the suggesters configured for a domain. A suggester enables you to
display possible matches before users finish typing their queries. Can
be limited to specific suggesters by name. By default, shows all
suggesters and includes any pending changes to the configuration. Set
the \code{Deployed} option to \code{true} to show the active configuration and
exclude pending changes. For more information, see \href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html}{Getting Search Suggestions}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_suggesters(
  DomainName = "string",
  SuggesterNames = list(
    "string"
  ),
  Deployed = TRUE|FALSE
)
}
}

\keyword{internal}
