% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_update_monitoring}
\alias{kafka_update_monitoring}
\title{Updates the monitoring settings for the cluster}
\usage{
kafka_update_monitoring(ClusterArn, CurrentVersion, EnhancedMonitoring,
  OpenMonitoring, LoggingInfo)
}
\arguments{
\item{ClusterArn}{[required]
<p>The Amazon Resource Name (ARN) that uniquely identifies the cluster.</p>}

\item{CurrentVersion}{[required]
<p>The version of the MSK cluster to update. Cluster versions aren't simple numbers. You can describe an MSK cluster to find its version. When this update operation is successful, it generates a new cluster version.</p>}

\item{EnhancedMonitoring}{<p>Specifies which Apache Kafka metrics Amazon MSK gathers and sends to Amazon CloudWatch for this cluster.</p>}

\item{OpenMonitoring}{<p>The settings for open monitoring.</p>}

\item{LoggingInfo}{}
}
\description{
\preformatted{        <p>Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.</p>
}
}
\section{Request syntax}{
\preformatted{svc$update_monitoring(
  ClusterArn = "string",
  CurrentVersion = "string",
  EnhancedMonitoring = "DEFAULT"|"PER_BROKER"|"PER_TOPIC_PER_BROKER",
  OpenMonitoring = list(
    Prometheus = list(
      JmxExporter = list(
        EnabledInBroker = TRUE|FALSE
      ),
      NodeExporter = list(
        EnabledInBroker = TRUE|FALSE
      )
    )
  ),
  LoggingInfo = list(
    BrokerLogs = list(
      CloudWatchLogs = list(
        Enabled = TRUE|FALSE,
        LogGroup = "string"
      ),
      Firehose = list(
        DeliveryStream = "string",
        Enabled = TRUE|FALSE
      ),
      S3 = list(
        Bucket = "string",
        Enabled = TRUE|FALSE,
        Prefix = "string"
      )
    )
  )
)
}
}

\keyword{internal}
