% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_ingestion}
\alias{quicksight_create_ingestion}
\title{Creates and starts a new SPICE ingestion on a dataset Any ingestions
operating on tagged datasets inherit the same tags automatically for use
in access control}
\usage{
quicksight_create_ingestion(DataSetId, IngestionId, AwsAccountId)
}
\arguments{
\item{DataSetId}{[required] The ID of the dataset used in the ingestion.}

\item{IngestionId}{[required] An ID for the ingestion.}

\item{AwsAccountId}{[required] The AWS account ID.}
}
\description{
Creates and starts a new SPICE ingestion on a dataset
}
\details{
Any ingestions operating on tagged datasets inherit the same tags
automatically for use in access control. For an example, see \href{https://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/}{How do I create an IAM policy to control access to Amazon EC2 resources using tags?}
in the AWS Knowledge Center. Tags are visible on the tagged dataset, but
not on the ingestion resource.
}
\section{Request syntax}{
\preformatted{svc$create_ingestion(
  DataSetId = "string",
  IngestionId = "string",
  AwsAccountId = "string"
)
}
}

\keyword{internal}
