% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_update_data_source_permissions}
\alias{quicksight_update_data_source_permissions}
\title{Updates the permissions to a data source}
\usage{
quicksight_update_data_source_permissions(AwsAccountId, DataSourceId,
  GrantPermissions, RevokePermissions)
}
\arguments{
\item{AwsAccountId}{[required] The AWS account ID.}

\item{DataSourceId}{[required] The ID of the data source. This ID is unique per AWS Region for each AWS
account.}

\item{GrantPermissions}{A list of resource permissions that you want to grant on the data
source.}

\item{RevokePermissions}{A list of resource permissions that you want to revoke on the data
source.}
}
\description{
Updates the permissions to a data source.
}
\section{Request syntax}{
\preformatted{svc$update_data_source_permissions(
  AwsAccountId = "string",
  DataSourceId = "string",
  GrantPermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  ),
  RevokePermissions = list(
    list(
      Principal = "string",
      Actions = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
