% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_get_dashboard_embed_url}
\alias{quicksight_get_dashboard_embed_url}
\title{Generates a temporary session URL and authorization code(bearer token)
that you can use to embed an Amazon QuickSight read-only dashboard in
your website or application}
\usage{
quicksight_get_dashboard_embed_url(
  AwsAccountId,
  DashboardId,
  IdentityType,
  SessionLifetimeInMinutes = NULL,
  UndoRedoDisabled = NULL,
  ResetDisabled = NULL,
  StatePersistenceEnabled = NULL,
  UserArn = NULL,
  Namespace = NULL,
  AdditionalDashboardIds = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that contains the dashboard
that you're embedding.}

\item{DashboardId}{[required] The ID for the dashboard, also added to the Identity and Access
Management (IAM) policy.}

\item{IdentityType}{[required] The authentication method that the user uses to sign in.}

\item{SessionLifetimeInMinutes}{How many minutes the session is valid. The session lifetime must be
15-600 minutes.}

\item{UndoRedoDisabled}{Remove the undo/redo button on the embedded dashboard. The default is
FALSE, which enables the undo/redo button.}

\item{ResetDisabled}{Remove the reset button on the embedded dashboard. The default is FALSE,
which enables the reset button.}

\item{StatePersistenceEnabled}{Adds persistence of state for the user session in an embedded dashboard.
Persistence applies to the sheet and the parameter settings. These are
control settings that the dashboard subscriber (Amazon QuickSight
reader) chooses while viewing the dashboard. If this is set to \code{TRUE},
the settings are the same when the subscriber reopens the same dashboard
URL. The state is stored in Amazon QuickSight, not in a browser cookie.
If this is set to FALSE, the state of the user session is not persisted.
The default is \code{FALSE}.}

\item{UserArn}{The Amazon QuickSight user's Amazon Resource Name (ARN), for use with
\code{QUICKSIGHT} identity type. You can use this for any Amazon QuickSight
users in your account (readers, authors, or admins) authenticated as one
of the following:
\itemize{
\item Active Directory (AD) users or group members
\item Invited nonfederated users
\item IAM users and IAM role-based sessions authenticated through
Federated Single Sign-On using SAML, OpenID Connect, or IAM
federation.
}

Omit this parameter for users in the third group – IAM users and IAM
role-based sessions.}

\item{Namespace}{The Amazon QuickSight namespace that contains the dashboard IDs in this
request. If you're not using a custom namespace, set
\code{Namespace = default}.}

\item{AdditionalDashboardIds}{A list of one or more dashboard IDs that you want anonymous users to
have tempporary access to. Currently, the \code{IdentityType} parameter must
be set to \code{ANONYMOUS} because other identity types authenticate as
Amazon QuickSight or IAM users. For example, if you set
"\verb{--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS}",
the session can access all three dashboards.}
}
\description{
Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.

See \url{https://www.paws-r-sdk.com/docs/quicksight_get_dashboard_embed_url/} for full documentation.
}
\keyword{internal}
