% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_projects}
\alias{datazone_list_projects}
\title{Lists Amazon DataZone projects}
\usage{
datazone_list_projects(
  domainIdentifier,
  groupIdentifier = NULL,
  maxResults = NULL,
  name = NULL,
  nextToken = NULL,
  userIdentifier = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{groupIdentifier}{The identifier of a group.}

\item{maxResults}{The maximum number of projects to return in a single call to
\code{\link[=datazone_list_projects]{list_projects}}. When the number of projects
to be listed is greater than the value of \code{MaxResults}, the response
contains a \code{NextToken} value that you can use in a subsequent call to
\code{\link[=datazone_list_projects]{list_projects}} to list the next set of
projects.}

\item{name}{}

\item{nextToken}{When the number of projects is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of projects, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_projects]{list_projects}} to list the next set of
projects.}

\item{userIdentifier}{The identifier of the Amazon DataZone user.}
}
\description{
Lists Amazon DataZone projects.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_projects/} for full documentation.
}
\keyword{internal}
