% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_search_listings}
\alias{datazone_search_listings}
\title{Searches listings in Amazon DataZone}
\usage{
datazone_search_listings(
  additionalAttributes = NULL,
  domainIdentifier,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL,
  searchIn = NULL,
  searchText = NULL,
  sort = NULL
)
}
\arguments{
\item{additionalAttributes}{Specifies additional attributes for the search.}

\item{domainIdentifier}{[required] The identifier of the domain in which to search listings.}

\item{filters}{Specifies the filters for the search of listings.}

\item{maxResults}{The maximum number of results to return in a single call to
\code{\link[=datazone_search_listings]{search_listings}}. When the number of
results to be listed is greater than the value of \code{MaxResults}, the
response contains a \code{NextToken} value that you can use in a subsequent
call to \code{\link[=datazone_search_listings]{search_listings}} to list the next
set of results.}

\item{nextToken}{When the number of results is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of results, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_search_listings]{search_listings}} to list the next set of
results.}

\item{searchIn}{}

\item{searchText}{Specifies the text for which to search.}

\item{sort}{Specifies the way for sorting the search results.}
}
\description{
Searches listings in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_search_listings/} for full documentation.
}
\keyword{internal}
