% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_subscription_target}
\alias{datazone_create_subscription_target}
\title{Creates a subscription target in Amazon DataZone}
\usage{
datazone_create_subscription_target(
  applicableAssetTypes,
  authorizedPrincipals,
  clientToken = NULL,
  domainIdentifier,
  environmentIdentifier,
  manageAccessRole,
  name,
  provider = NULL,
  subscriptionTargetConfig,
  type
)
}
\arguments{
\item{applicableAssetTypes}{[required] The asset types that can be included in the subscription target.}

\item{authorizedPrincipals}{[required] The authorized principals of the subscription target.}

\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{domainIdentifier}{[required] The ID of the Amazon DataZone domain in which subscription target is
created.}

\item{environmentIdentifier}{[required] The ID of the environment in which subscription target is created.}

\item{manageAccessRole}{[required] The manage access role that is used to create the subscription target.}

\item{name}{[required] The name of the subscription target.}

\item{provider}{The provider of the subscription target.}

\item{subscriptionTargetConfig}{[required] The configuration of the subscription target.}

\item{type}{[required] The type of the subscription target.}
}
\description{
Creates a subscription target in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_subscription_target/} for full documentation.
}
\keyword{internal}
