# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include gluedatabrew_service.R
NULL

#' Deletes one or more versions of a recipe at a time
#'
#' @description
#' Deletes one or more versions of a recipe at a time.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_batch_delete_recipe_version/](https://www.paws-r-sdk.com/docs/gluedatabrew_batch_delete_recipe_version/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the recipe whose versions are to be deleted.
#' @param RecipeVersions &#91;required&#93; An array of version identifiers, for the recipe versions to be deleted.
#' You can specify numeric versions (`X.Y`) or `LATEST_WORKING`.
#' `LATEST_PUBLISHED` is not supported.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_batch_delete_recipe_version
gluedatabrew_batch_delete_recipe_version <- function(Name, RecipeVersions) {
  op <- new_operation(
    name = "BatchDeleteRecipeVersion",
    http_method = "POST",
    http_path = "/recipes/{name}/batchDeleteRecipeVersion",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$batch_delete_recipe_version_input(Name = Name, RecipeVersions = RecipeVersions)
  output <- .gluedatabrew$batch_delete_recipe_version_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$batch_delete_recipe_version <- gluedatabrew_batch_delete_recipe_version

#' Creates a new DataBrew dataset
#'
#' @description
#' Creates a new DataBrew dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_dataset/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_dataset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the dataset to be created. Valid characters are alphanumeric
#' (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
#' @param Format The file format of a dataset that is created from an Amazon S3 file or
#' folder.
#' @param FormatOptions 
#' @param Input &#91;required&#93; 
#' @param PathOptions A set of options that defines how DataBrew interprets an Amazon S3 path
#' of the dataset.
#' @param Tags Metadata tags to apply to this dataset.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_dataset
gluedatabrew_create_dataset <- function(Name, Format = NULL, FormatOptions = NULL, Input, PathOptions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/datasets",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_dataset_input(Name = Name, Format = Format, FormatOptions = FormatOptions, Input = Input, PathOptions = PathOptions, Tags = Tags)
  output <- .gluedatabrew$create_dataset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_dataset <- gluedatabrew_create_dataset

#' Creates a new job to analyze a dataset and create its data profile
#'
#' @description
#' Creates a new job to analyze a dataset and create its data profile.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_profile_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_profile_job/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of the dataset that this job is to act upon.
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) of an encryption key that is used to
#' protect the job.
#' @param EncryptionMode The encryption mode for the job, which can be one of the following:
#' 
#' -   `SSE-KMS` - `SSE-KMS` - Server-side encryption with KMS-managed
#'     keys.
#' 
#' -   `SSE-S3` - Server-side encryption with keys managed by Amazon S3.
#' @param Name &#91;required&#93; The name of the job to be created. Valid characters are alphanumeric
#' (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
#' @param LogSubscription Enables or disables Amazon CloudWatch logging for the job. If logging is
#' enabled, CloudWatch writes one log stream for each job run.
#' @param MaxCapacity The maximum number of nodes that DataBrew can use when the job processes
#' data.
#' @param MaxRetries The maximum number of times to retry the job after a job run fails.
#' @param OutputLocation &#91;required&#93; 
#' @param Configuration Configuration for profile jobs. Used to select columns, do evaluations,
#' and override default parameters of evaluations. When configuration is
#' null, the profile job will run with default settings.
#' @param ValidationConfigurations List of validation configurations that are applied to the profile job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role to be assumed when DataBrew runs the job.
#' @param Tags Metadata tags to apply to this job.
#' @param Timeout The job's timeout in minutes. A job that attempts to run longer than
#' this timeout period ends with a status of `TIMEOUT`.
#' @param JobSample Sample configuration for profile jobs only. Determines the number of
#' rows on which the profile job will be executed. If a JobSample value is
#' not provided, the default value will be used. The default value is
#' CUSTOM_ROWS for the mode parameter and 20000 for the size parameter.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_profile_job
gluedatabrew_create_profile_job <- function(DatasetName, EncryptionKeyArn = NULL, EncryptionMode = NULL, Name, LogSubscription = NULL, MaxCapacity = NULL, MaxRetries = NULL, OutputLocation, Configuration = NULL, ValidationConfigurations = NULL, RoleArn, Tags = NULL, Timeout = NULL, JobSample = NULL) {
  op <- new_operation(
    name = "CreateProfileJob",
    http_method = "POST",
    http_path = "/profileJobs",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_profile_job_input(DatasetName = DatasetName, EncryptionKeyArn = EncryptionKeyArn, EncryptionMode = EncryptionMode, Name = Name, LogSubscription = LogSubscription, MaxCapacity = MaxCapacity, MaxRetries = MaxRetries, OutputLocation = OutputLocation, Configuration = Configuration, ValidationConfigurations = ValidationConfigurations, RoleArn = RoleArn, Tags = Tags, Timeout = Timeout, JobSample = JobSample)
  output <- .gluedatabrew$create_profile_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_profile_job <- gluedatabrew_create_profile_job

#' Creates a new DataBrew project
#'
#' @description
#' Creates a new DataBrew project.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_project/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_project/) for full documentation.
#'
#' @param DatasetName &#91;required&#93; The name of an existing dataset to associate this project with.
#' @param Name &#91;required&#93; A unique name for the new project. Valid characters are alphanumeric
#' (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
#' @param RecipeName &#91;required&#93; The name of an existing recipe to associate with the project.
#' @param Sample 
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role to be assumed for this request.
#' @param Tags Metadata tags to apply to this project.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_project
gluedatabrew_create_project <- function(DatasetName, Name, RecipeName, Sample = NULL, RoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/projects",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_project_input(DatasetName = DatasetName, Name = Name, RecipeName = RecipeName, Sample = Sample, RoleArn = RoleArn, Tags = Tags)
  output <- .gluedatabrew$create_project_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_project <- gluedatabrew_create_project

#' Creates a new DataBrew recipe
#'
#' @description
#' Creates a new DataBrew recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_recipe/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_recipe/) for full documentation.
#'
#' @param Description A description for the recipe.
#' @param Name &#91;required&#93; A unique name for the recipe. Valid characters are alphanumeric (A-Z,
#' a-z, 0-9), hyphen (-), period (.), and space.
#' @param Steps &#91;required&#93; An array containing the steps to be performed by the recipe. Each recipe
#' step consists of one recipe action and (optionally) an array of
#' condition expressions.
#' @param Tags Metadata tags to apply to this recipe.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_recipe
gluedatabrew_create_recipe <- function(Description = NULL, Name, Steps, Tags = NULL) {
  op <- new_operation(
    name = "CreateRecipe",
    http_method = "POST",
    http_path = "/recipes",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_recipe_input(Description = Description, Name = Name, Steps = Steps, Tags = Tags)
  output <- .gluedatabrew$create_recipe_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_recipe <- gluedatabrew_create_recipe

#' Creates a new job to transform input data, using steps defined in an
#' existing Glue DataBrew recipe
#'
#' @description
#' Creates a new job to transform input data, using steps defined in an existing Glue DataBrew recipe
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_recipe_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_recipe_job/) for full documentation.
#'
#' @param DatasetName The name of the dataset that this job processes.
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) of an encryption key that is used to
#' protect the job.
#' @param EncryptionMode The encryption mode for the job, which can be one of the following:
#' 
#' -   `SSE-KMS` - Server-side encryption with keys managed by KMS.
#' 
#' -   `SSE-S3` - Server-side encryption with keys managed by Amazon S3.
#' @param Name &#91;required&#93; A unique name for the job. Valid characters are alphanumeric (A-Z, a-z,
#' 0-9), hyphen (-), period (.), and space.
#' @param LogSubscription Enables or disables Amazon CloudWatch logging for the job. If logging is
#' enabled, CloudWatch writes one log stream for each job run.
#' @param MaxCapacity The maximum number of nodes that DataBrew can consume when the job
#' processes data.
#' @param MaxRetries The maximum number of times to retry the job after a job run fails.
#' @param Outputs One or more artifacts that represent the output from running the job.
#' @param DataCatalogOutputs One or more artifacts that represent the Glue Data Catalog output from
#' running the job.
#' @param DatabaseOutputs Represents a list of JDBC database output objects which defines the
#' output destination for a DataBrew recipe job to write to.
#' @param ProjectName Either the name of an existing project, or a combination of a recipe and
#' a dataset to associate with the recipe.
#' @param RecipeReference 
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role to be assumed when DataBrew runs the job.
#' @param Tags Metadata tags to apply to this job.
#' @param Timeout The job's timeout in minutes. A job that attempts to run longer than
#' this timeout period ends with a status of `TIMEOUT`.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_recipe_job
gluedatabrew_create_recipe_job <- function(DatasetName = NULL, EncryptionKeyArn = NULL, EncryptionMode = NULL, Name, LogSubscription = NULL, MaxCapacity = NULL, MaxRetries = NULL, Outputs = NULL, DataCatalogOutputs = NULL, DatabaseOutputs = NULL, ProjectName = NULL, RecipeReference = NULL, RoleArn, Tags = NULL, Timeout = NULL) {
  op <- new_operation(
    name = "CreateRecipeJob",
    http_method = "POST",
    http_path = "/recipeJobs",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_recipe_job_input(DatasetName = DatasetName, EncryptionKeyArn = EncryptionKeyArn, EncryptionMode = EncryptionMode, Name = Name, LogSubscription = LogSubscription, MaxCapacity = MaxCapacity, MaxRetries = MaxRetries, Outputs = Outputs, DataCatalogOutputs = DataCatalogOutputs, DatabaseOutputs = DatabaseOutputs, ProjectName = ProjectName, RecipeReference = RecipeReference, RoleArn = RoleArn, Tags = Tags, Timeout = Timeout)
  output <- .gluedatabrew$create_recipe_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_recipe_job <- gluedatabrew_create_recipe_job

#' Creates a new ruleset that can be used in a profile job to validate the
#' data quality of a dataset
#'
#' @description
#' Creates a new ruleset that can be used in a profile job to validate the data quality of a dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_ruleset/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ruleset to be created. Valid characters are alphanumeric
#' (A-Z, a-z, 0-9), hyphen (-), period (.), and space.
#' @param Description The description of the ruleset.
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset
#' is associated with.
#' @param Rules &#91;required&#93; A list of rules that are defined with the ruleset. A rule includes one
#' or more checks to be validated on a DataBrew dataset.
#' @param Tags Metadata tags to apply to the ruleset.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_ruleset
gluedatabrew_create_ruleset <- function(Name, Description = NULL, TargetArn, Rules, Tags = NULL) {
  op <- new_operation(
    name = "CreateRuleset",
    http_method = "POST",
    http_path = "/rulesets",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_ruleset_input(Name = Name, Description = Description, TargetArn = TargetArn, Rules = Rules, Tags = Tags)
  output <- .gluedatabrew$create_ruleset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_ruleset <- gluedatabrew_create_ruleset

#' Creates a new schedule for one or more DataBrew jobs
#'
#' @description
#' Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular intervals.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_create_schedule/](https://www.paws-r-sdk.com/docs/gluedatabrew_create_schedule/) for full documentation.
#'
#' @param JobNames The name or names of one or more jobs to be run.
#' @param CronExpression &#91;required&#93; The date or dates and time or times when the jobs are to be run. For
#' more information, see [Cron
#' expressions](https://docs.aws.amazon.com/databrew/latest/dg/) in the
#' *Glue DataBrew Developer Guide*.
#' @param Tags Metadata tags to apply to this schedule.
#' @param Name &#91;required&#93; A unique name for the schedule. Valid characters are alphanumeric (A-Z,
#' a-z, 0-9), hyphen (-), period (.), and space.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_create_schedule
gluedatabrew_create_schedule <- function(JobNames = NULL, CronExpression, Tags = NULL, Name) {
  op <- new_operation(
    name = "CreateSchedule",
    http_method = "POST",
    http_path = "/schedules",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$create_schedule_input(JobNames = JobNames, CronExpression = CronExpression, Tags = Tags, Name = Name)
  output <- .gluedatabrew$create_schedule_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$create_schedule <- gluedatabrew_create_schedule

#' Deletes a dataset from DataBrew
#'
#' @description
#' Deletes a dataset from DataBrew.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_dataset/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_dataset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the dataset to be deleted.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_dataset
gluedatabrew_delete_dataset <- function(Name) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "DELETE",
    http_path = "/datasets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_dataset_input(Name = Name)
  output <- .gluedatabrew$delete_dataset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_dataset <- gluedatabrew_delete_dataset

#' Deletes the specified DataBrew job
#'
#' @description
#' Deletes the specified DataBrew job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_job/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job to be deleted.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_job
gluedatabrew_delete_job <- function(Name) {
  op <- new_operation(
    name = "DeleteJob",
    http_method = "DELETE",
    http_path = "/jobs/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_job_input(Name = Name)
  output <- .gluedatabrew$delete_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_job <- gluedatabrew_delete_job

#' Deletes an existing DataBrew project
#'
#' @description
#' Deletes an existing DataBrew project.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_project/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_project/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the project to be deleted.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_project
gluedatabrew_delete_project <- function(Name) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "DELETE",
    http_path = "/projects/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_project_input(Name = Name)
  output <- .gluedatabrew$delete_project_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_project <- gluedatabrew_delete_project

#' Deletes a single version of a DataBrew recipe
#'
#' @description
#' Deletes a single version of a DataBrew recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_recipe_version/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_recipe_version/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the recipe.
#' @param RecipeVersion &#91;required&#93; The version of the recipe to be deleted. You can specify a numeric
#' versions (`X.Y`) or `LATEST_WORKING`. `LATEST_PUBLISHED` is not
#' supported.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_recipe_version
gluedatabrew_delete_recipe_version <- function(Name, RecipeVersion) {
  op <- new_operation(
    name = "DeleteRecipeVersion",
    http_method = "DELETE",
    http_path = "/recipes/{name}/recipeVersion/{recipeVersion}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_recipe_version_input(Name = Name, RecipeVersion = RecipeVersion)
  output <- .gluedatabrew$delete_recipe_version_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_recipe_version <- gluedatabrew_delete_recipe_version

#' Deletes a ruleset
#'
#' @description
#' Deletes a ruleset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_ruleset/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ruleset to be deleted.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_ruleset
gluedatabrew_delete_ruleset <- function(Name) {
  op <- new_operation(
    name = "DeleteRuleset",
    http_method = "DELETE",
    http_path = "/rulesets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_ruleset_input(Name = Name)
  output <- .gluedatabrew$delete_ruleset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_ruleset <- gluedatabrew_delete_ruleset

#' Deletes the specified DataBrew schedule
#'
#' @description
#' Deletes the specified DataBrew schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_delete_schedule/](https://www.paws-r-sdk.com/docs/gluedatabrew_delete_schedule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the schedule to be deleted.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_delete_schedule
gluedatabrew_delete_schedule <- function(Name) {
  op <- new_operation(
    name = "DeleteSchedule",
    http_method = "DELETE",
    http_path = "/schedules/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$delete_schedule_input(Name = Name)
  output <- .gluedatabrew$delete_schedule_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$delete_schedule <- gluedatabrew_delete_schedule

#' Returns the definition of a specific DataBrew dataset
#'
#' @description
#' Returns the definition of a specific DataBrew dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_dataset/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_dataset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the dataset to be described.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_dataset
gluedatabrew_describe_dataset <- function(Name) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "GET",
    http_path = "/datasets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_dataset_input(Name = Name)
  output <- .gluedatabrew$describe_dataset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_dataset <- gluedatabrew_describe_dataset

#' Returns the definition of a specific DataBrew job
#'
#' @description
#' Returns the definition of a specific DataBrew job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_job/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job to be described.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_job
gluedatabrew_describe_job <- function(Name) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/jobs/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_job_input(Name = Name)
  output <- .gluedatabrew$describe_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_job <- gluedatabrew_describe_job

#' Represents one run of a DataBrew job
#'
#' @description
#' Represents one run of a DataBrew job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_job_run/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_job_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job being processed during this run.
#' @param RunId &#91;required&#93; The unique identifier of the job run.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_job_run
gluedatabrew_describe_job_run <- function(Name, RunId) {
  op <- new_operation(
    name = "DescribeJobRun",
    http_method = "GET",
    http_path = "/jobs/{name}/jobRun/{runId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_job_run_input(Name = Name, RunId = RunId)
  output <- .gluedatabrew$describe_job_run_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_job_run <- gluedatabrew_describe_job_run

#' Returns the definition of a specific DataBrew project
#'
#' @description
#' Returns the definition of a specific DataBrew project.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_project/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_project/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the project to be described.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_project
gluedatabrew_describe_project <- function(Name) {
  op <- new_operation(
    name = "DescribeProject",
    http_method = "GET",
    http_path = "/projects/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_project_input(Name = Name)
  output <- .gluedatabrew$describe_project_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_project <- gluedatabrew_describe_project

#' Returns the definition of a specific DataBrew recipe corresponding to a
#' particular version
#'
#' @description
#' Returns the definition of a specific DataBrew recipe corresponding to a particular version.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_recipe/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_recipe/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the recipe to be described.
#' @param RecipeVersion The recipe version identifier. If this parameter isn't specified, then
#' the latest published version is returned.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_recipe
gluedatabrew_describe_recipe <- function(Name, RecipeVersion = NULL) {
  op <- new_operation(
    name = "DescribeRecipe",
    http_method = "GET",
    http_path = "/recipes/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_recipe_input(Name = Name, RecipeVersion = RecipeVersion)
  output <- .gluedatabrew$describe_recipe_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_recipe <- gluedatabrew_describe_recipe

#' Retrieves detailed information about the ruleset
#'
#' @description
#' Retrieves detailed information about the ruleset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_ruleset/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ruleset to be described.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_ruleset
gluedatabrew_describe_ruleset <- function(Name) {
  op <- new_operation(
    name = "DescribeRuleset",
    http_method = "GET",
    http_path = "/rulesets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_ruleset_input(Name = Name)
  output <- .gluedatabrew$describe_ruleset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_ruleset <- gluedatabrew_describe_ruleset

#' Returns the definition of a specific DataBrew schedule
#'
#' @description
#' Returns the definition of a specific DataBrew schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_describe_schedule/](https://www.paws-r-sdk.com/docs/gluedatabrew_describe_schedule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the schedule to be described.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_describe_schedule
gluedatabrew_describe_schedule <- function(Name) {
  op <- new_operation(
    name = "DescribeSchedule",
    http_method = "GET",
    http_path = "/schedules/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$describe_schedule_input(Name = Name)
  output <- .gluedatabrew$describe_schedule_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$describe_schedule <- gluedatabrew_describe_schedule

#' Lists all of the DataBrew datasets
#'
#' @description
#' Lists all of the DataBrew datasets.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_datasets/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_datasets/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_datasets
gluedatabrew_list_datasets <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "GET",
    http_path = "/datasets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Datasets")
  )
  input <- .gluedatabrew$list_datasets_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .gluedatabrew$list_datasets_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_datasets <- gluedatabrew_list_datasets

#' Lists all of the previous runs of a particular DataBrew job
#'
#' @description
#' Lists all of the previous runs of a particular DataBrew job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_job_runs/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_job_runs/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job.
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_job_runs
gluedatabrew_list_job_runs <- function(Name, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListJobRuns",
    http_method = "GET",
    http_path = "/jobs/{name}/jobRuns",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "JobRuns")
  )
  input <- .gluedatabrew$list_job_runs_input(Name = Name, MaxResults = MaxResults, NextToken = NextToken)
  output <- .gluedatabrew$list_job_runs_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_job_runs <- gluedatabrew_list_job_runs

#' Lists all of the DataBrew jobs that are defined
#'
#' @description
#' Lists all of the DataBrew jobs that are defined.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_jobs/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_jobs/) for full documentation.
#'
#' @param DatasetName The name of a dataset. Using this parameter indicates to return only
#' those jobs that act on the specified dataset.
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken A token generated by DataBrew that specifies where to continue
#' pagination if a previous request was truncated. To get the next set of
#' pages, pass in the NextToken value from the response object of the
#' previous page call.
#' @param ProjectName The name of a project. Using this parameter indicates to return only
#' those jobs that are associated with the specified project.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_jobs
gluedatabrew_list_jobs <- function(DatasetName = NULL, MaxResults = NULL, NextToken = NULL, ProjectName = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/jobs",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Jobs")
  )
  input <- .gluedatabrew$list_jobs_input(DatasetName = DatasetName, MaxResults = MaxResults, NextToken = NextToken, ProjectName = ProjectName)
  output <- .gluedatabrew$list_jobs_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_jobs <- gluedatabrew_list_jobs

#' Lists all of the DataBrew projects that are defined
#'
#' @description
#' Lists all of the DataBrew projects that are defined.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_projects/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_projects/) for full documentation.
#'
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_projects
gluedatabrew_list_projects <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "GET",
    http_path = "/projects",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Projects")
  )
  input <- .gluedatabrew$list_projects_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .gluedatabrew$list_projects_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_projects <- gluedatabrew_list_projects

#' Lists the versions of a particular DataBrew recipe, except for
#' LATEST_WORKING
#'
#' @description
#' Lists the versions of a particular DataBrew recipe, except for `LATEST_WORKING`.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_recipe_versions/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_recipe_versions/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Name &#91;required&#93; The name of the recipe for which to return version information.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_recipe_versions
gluedatabrew_list_recipe_versions <- function(MaxResults = NULL, NextToken = NULL, Name) {
  op <- new_operation(
    name = "ListRecipeVersions",
    http_method = "GET",
    http_path = "/recipeVersions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Recipes")
  )
  input <- .gluedatabrew$list_recipe_versions_input(MaxResults = MaxResults, NextToken = NextToken, Name = Name)
  output <- .gluedatabrew$list_recipe_versions_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_recipe_versions <- gluedatabrew_list_recipe_versions

#' Lists all of the DataBrew recipes that are defined
#'
#' @description
#' Lists all of the DataBrew recipes that are defined.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_recipes/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_recipes/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param RecipeVersion Return only those recipes with a version identifier of `LATEST_WORKING`
#' or `LATEST_PUBLISHED`. If `RecipeVersion` is omitted,
#' [`list_recipes`][gluedatabrew_list_recipes] returns all of the
#' `LATEST_PUBLISHED` recipe versions.
#' 
#' Valid values: `LATEST_WORKING` | `LATEST_PUBLISHED`
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_recipes
gluedatabrew_list_recipes <- function(MaxResults = NULL, NextToken = NULL, RecipeVersion = NULL) {
  op <- new_operation(
    name = "ListRecipes",
    http_method = "GET",
    http_path = "/recipes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Recipes")
  )
  input <- .gluedatabrew$list_recipes_input(MaxResults = MaxResults, NextToken = NextToken, RecipeVersion = RecipeVersion)
  output <- .gluedatabrew$list_recipes_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_recipes <- gluedatabrew_list_recipes

#' List all rulesets available in the current account or rulesets
#' associated with a specific resource (dataset)
#'
#' @description
#' List all rulesets available in the current account or rulesets associated with a specific resource (dataset).
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_rulesets/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_rulesets/) for full documentation.
#'
#' @param TargetArn The Amazon Resource Name (ARN) of a resource (dataset). Using this
#' parameter indicates to return only those rulesets that are associated
#' with the specified resource.
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken A token generated by DataBrew that specifies where to continue
#' pagination if a previous request was truncated. To get the next set of
#' pages, pass in the NextToken value from the response object of the
#' previous page call.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_rulesets
gluedatabrew_list_rulesets <- function(TargetArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRulesets",
    http_method = "GET",
    http_path = "/rulesets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Rulesets")
  )
  input <- .gluedatabrew$list_rulesets_input(TargetArn = TargetArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .gluedatabrew$list_rulesets_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_rulesets <- gluedatabrew_list_rulesets

#' Lists the DataBrew schedules that are defined
#'
#' @description
#' Lists the DataBrew schedules that are defined.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_schedules/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_schedules/) for full documentation.
#'
#' @param JobName The name of the job that these schedules apply to.
#' @param MaxResults The maximum number of results to return in this request.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_schedules
gluedatabrew_list_schedules <- function(JobName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSchedules",
    http_method = "GET",
    http_path = "/schedules",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Schedules")
  )
  input <- .gluedatabrew$list_schedules_input(JobName = JobName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .gluedatabrew$list_schedules_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_schedules <- gluedatabrew_list_schedules

#' Lists all the tags for a DataBrew resource
#'
#' @description
#' Lists all the tags for a DataBrew resource.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/gluedatabrew_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) string that uniquely identifies the
#' DataBrew resource.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_list_tags_for_resource
gluedatabrew_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .gluedatabrew$list_tags_for_resource_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$list_tags_for_resource <- gluedatabrew_list_tags_for_resource

#' Publishes a new version of a DataBrew recipe
#'
#' @description
#' Publishes a new version of a DataBrew recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_publish_recipe/](https://www.paws-r-sdk.com/docs/gluedatabrew_publish_recipe/) for full documentation.
#'
#' @param Description A description of the recipe to be published, for this version of the
#' recipe.
#' @param Name &#91;required&#93; The name of the recipe to be published.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_publish_recipe
gluedatabrew_publish_recipe <- function(Description = NULL, Name) {
  op <- new_operation(
    name = "PublishRecipe",
    http_method = "POST",
    http_path = "/recipes/{name}/publishRecipe",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$publish_recipe_input(Description = Description, Name = Name)
  output <- .gluedatabrew$publish_recipe_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$publish_recipe <- gluedatabrew_publish_recipe

#' Performs a recipe step within an interactive DataBrew session that's
#' currently open
#'
#' @description
#' Performs a recipe step within an interactive DataBrew session that's currently open.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_send_project_session_action/](https://www.paws-r-sdk.com/docs/gluedatabrew_send_project_session_action/) for full documentation.
#'
#' @param Preview If true, the result of the recipe step will be returned, but not
#' applied.
#' @param Name &#91;required&#93; The name of the project to apply the action to.
#' @param RecipeStep 
#' @param StepIndex The index from which to preview a step. This index is used to preview
#' the result of steps that have already been applied, so that the
#' resulting view frame is from earlier in the view frame stack.
#' @param ClientSessionId A unique identifier for an interactive session that's currently open and
#' ready for work. The action will be performed on this session.
#' @param ViewFrame 
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_send_project_session_action
gluedatabrew_send_project_session_action <- function(Preview = NULL, Name, RecipeStep = NULL, StepIndex = NULL, ClientSessionId = NULL, ViewFrame = NULL) {
  op <- new_operation(
    name = "SendProjectSessionAction",
    http_method = "PUT",
    http_path = "/projects/{name}/sendProjectSessionAction",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$send_project_session_action_input(Preview = Preview, Name = Name, RecipeStep = RecipeStep, StepIndex = StepIndex, ClientSessionId = ClientSessionId, ViewFrame = ViewFrame)
  output <- .gluedatabrew$send_project_session_action_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$send_project_session_action <- gluedatabrew_send_project_session_action

#' Runs a DataBrew job
#'
#' @description
#' Runs a DataBrew job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_start_job_run/](https://www.paws-r-sdk.com/docs/gluedatabrew_start_job_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job to be run.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_start_job_run
gluedatabrew_start_job_run <- function(Name) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/jobs/{name}/startJobRun",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$start_job_run_input(Name = Name)
  output <- .gluedatabrew$start_job_run_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$start_job_run <- gluedatabrew_start_job_run

#' Creates an interactive session, enabling you to manipulate data in a
#' DataBrew project
#'
#' @description
#' Creates an interactive session, enabling you to manipulate data in a DataBrew project.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_start_project_session/](https://www.paws-r-sdk.com/docs/gluedatabrew_start_project_session/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the project to act upon.
#' @param AssumeControl A value that, if true, enables you to take control of a session, even if
#' a different client is currently accessing the project.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_start_project_session
gluedatabrew_start_project_session <- function(Name, AssumeControl = NULL) {
  op <- new_operation(
    name = "StartProjectSession",
    http_method = "PUT",
    http_path = "/projects/{name}/startProjectSession",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$start_project_session_input(Name = Name, AssumeControl = AssumeControl)
  output <- .gluedatabrew$start_project_session_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$start_project_session <- gluedatabrew_start_project_session

#' Stops a particular run of a job
#'
#' @description
#' Stops a particular run of a job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_stop_job_run/](https://www.paws-r-sdk.com/docs/gluedatabrew_stop_job_run/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the job to be stopped.
#' @param RunId &#91;required&#93; The ID of the job run to be stopped.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_stop_job_run
gluedatabrew_stop_job_run <- function(Name, RunId) {
  op <- new_operation(
    name = "StopJobRun",
    http_method = "POST",
    http_path = "/jobs/{name}/jobRun/{runId}/stopJobRun",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$stop_job_run_input(Name = Name, RunId = RunId)
  output <- .gluedatabrew$stop_job_run_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$stop_job_run <- gluedatabrew_stop_job_run

#' Adds metadata tags to a DataBrew resource, such as a dataset, project,
#' recipe, job, or schedule
#'
#' @description
#' Adds metadata tags to a DataBrew resource, such as a dataset, project, recipe, job, or schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_tag_resource/](https://www.paws-r-sdk.com/docs/gluedatabrew_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The DataBrew resource to which tags should be added. The value for this
#' parameter is an Amazon Resource Name (ARN). For DataBrew, you can tag a
#' dataset, a job, a project, or a recipe.
#' @param Tags &#91;required&#93; One or more tags to be assigned to the resource.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_tag_resource
gluedatabrew_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .gluedatabrew$tag_resource_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$tag_resource <- gluedatabrew_tag_resource

#' Removes metadata tags from a DataBrew resource
#'
#' @description
#' Removes metadata tags from a DataBrew resource.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_untag_resource/](https://www.paws-r-sdk.com/docs/gluedatabrew_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; A DataBrew resource from which you want to remove a tag or tags. The
#' value for this parameter is an Amazon Resource Name (ARN).
#' @param TagKeys &#91;required&#93; The tag keys (names) of one or more tags to be removed.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_untag_resource
gluedatabrew_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .gluedatabrew$untag_resource_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$untag_resource <- gluedatabrew_untag_resource

#' Modifies the definition of an existing DataBrew dataset
#'
#' @description
#' Modifies the definition of an existing DataBrew dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_dataset/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_dataset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the dataset to be updated.
#' @param Format The file format of a dataset that is created from an Amazon S3 file or
#' folder.
#' @param FormatOptions 
#' @param Input &#91;required&#93; 
#' @param PathOptions A set of options that defines how DataBrew interprets an Amazon S3 path
#' of the dataset.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_dataset
gluedatabrew_update_dataset <- function(Name, Format = NULL, FormatOptions = NULL, Input, PathOptions = NULL) {
  op <- new_operation(
    name = "UpdateDataset",
    http_method = "PUT",
    http_path = "/datasets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_dataset_input(Name = Name, Format = Format, FormatOptions = FormatOptions, Input = Input, PathOptions = PathOptions)
  output <- .gluedatabrew$update_dataset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_dataset <- gluedatabrew_update_dataset

#' Modifies the definition of an existing profile job
#'
#' @description
#' Modifies the definition of an existing profile job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_profile_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_profile_job/) for full documentation.
#'
#' @param Configuration Configuration for profile jobs. Used to select columns, do evaluations,
#' and override default parameters of evaluations. When configuration is
#' null, the profile job will run with default settings.
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) of an encryption key that is used to
#' protect the job.
#' @param EncryptionMode The encryption mode for the job, which can be one of the following:
#' 
#' -   `SSE-KMS` - Server-side encryption with keys managed by KMS.
#' 
#' -   `SSE-S3` - Server-side encryption with keys managed by Amazon S3.
#' @param Name &#91;required&#93; The name of the job to be updated.
#' @param LogSubscription Enables or disables Amazon CloudWatch logging for the job. If logging is
#' enabled, CloudWatch writes one log stream for each job run.
#' @param MaxCapacity The maximum number of compute nodes that DataBrew can use when the job
#' processes data.
#' @param MaxRetries The maximum number of times to retry the job after a job run fails.
#' @param OutputLocation &#91;required&#93; 
#' @param ValidationConfigurations List of validation configurations that are applied to the profile job.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role to be assumed when DataBrew runs the job.
#' @param Timeout The job's timeout in minutes. A job that attempts to run longer than
#' this timeout period ends with a status of `TIMEOUT`.
#' @param JobSample Sample configuration for Profile Jobs only. Determines the number of
#' rows on which the Profile job will be executed. If a JobSample value is
#' not provided for profile jobs, the default value will be used. The
#' default value is CUSTOM_ROWS for the mode parameter and 20000 for the
#' size parameter.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_profile_job
gluedatabrew_update_profile_job <- function(Configuration = NULL, EncryptionKeyArn = NULL, EncryptionMode = NULL, Name, LogSubscription = NULL, MaxCapacity = NULL, MaxRetries = NULL, OutputLocation, ValidationConfigurations = NULL, RoleArn, Timeout = NULL, JobSample = NULL) {
  op <- new_operation(
    name = "UpdateProfileJob",
    http_method = "PUT",
    http_path = "/profileJobs/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_profile_job_input(Configuration = Configuration, EncryptionKeyArn = EncryptionKeyArn, EncryptionMode = EncryptionMode, Name = Name, LogSubscription = LogSubscription, MaxCapacity = MaxCapacity, MaxRetries = MaxRetries, OutputLocation = OutputLocation, ValidationConfigurations = ValidationConfigurations, RoleArn = RoleArn, Timeout = Timeout, JobSample = JobSample)
  output <- .gluedatabrew$update_profile_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_profile_job <- gluedatabrew_update_profile_job

#' Modifies the definition of an existing DataBrew project
#'
#' @description
#' Modifies the definition of an existing DataBrew project.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_project/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_project/) for full documentation.
#'
#' @param Sample 
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to be assumed for this
#' request.
#' @param Name &#91;required&#93; The name of the project to be updated.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_project
gluedatabrew_update_project <- function(Sample = NULL, RoleArn, Name) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "PUT",
    http_path = "/projects/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_project_input(Sample = Sample, RoleArn = RoleArn, Name = Name)
  output <- .gluedatabrew$update_project_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_project <- gluedatabrew_update_project

#' Modifies the definition of the LATEST_WORKING version of a DataBrew
#' recipe
#'
#' @description
#' Modifies the definition of the `LATEST_WORKING` version of a DataBrew recipe.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_recipe/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_recipe/) for full documentation.
#'
#' @param Description A description of the recipe.
#' @param Name &#91;required&#93; The name of the recipe to be updated.
#' @param Steps One or more steps to be performed by the recipe. Each step consists of
#' an action, and the conditions under which the action should succeed.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_recipe
gluedatabrew_update_recipe <- function(Description = NULL, Name, Steps = NULL) {
  op <- new_operation(
    name = "UpdateRecipe",
    http_method = "PUT",
    http_path = "/recipes/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_recipe_input(Description = Description, Name = Name, Steps = Steps)
  output <- .gluedatabrew$update_recipe_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_recipe <- gluedatabrew_update_recipe

#' Modifies the definition of an existing DataBrew recipe job
#'
#' @description
#' Modifies the definition of an existing DataBrew recipe job.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_recipe_job/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_recipe_job/) for full documentation.
#'
#' @param EncryptionKeyArn The Amazon Resource Name (ARN) of an encryption key that is used to
#' protect the job.
#' @param EncryptionMode The encryption mode for the job, which can be one of the following:
#' 
#' -   `SSE-KMS` - Server-side encryption with keys managed by KMS.
#' 
#' -   `SSE-S3` - Server-side encryption with keys managed by Amazon S3.
#' @param Name &#91;required&#93; The name of the job to update.
#' @param LogSubscription Enables or disables Amazon CloudWatch logging for the job. If logging is
#' enabled, CloudWatch writes one log stream for each job run.
#' @param MaxCapacity The maximum number of nodes that DataBrew can consume when the job
#' processes data.
#' @param MaxRetries The maximum number of times to retry the job after a job run fails.
#' @param Outputs One or more artifacts that represent the output from running the job.
#' @param DataCatalogOutputs One or more artifacts that represent the Glue Data Catalog output from
#' running the job.
#' @param DatabaseOutputs Represents a list of JDBC database output objects which defines the
#' output destination for a DataBrew recipe job to write into.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the Identity and Access Management
#' (IAM) role to be assumed when DataBrew runs the job.
#' @param Timeout The job's timeout in minutes. A job that attempts to run longer than
#' this timeout period ends with a status of `TIMEOUT`.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_recipe_job
gluedatabrew_update_recipe_job <- function(EncryptionKeyArn = NULL, EncryptionMode = NULL, Name, LogSubscription = NULL, MaxCapacity = NULL, MaxRetries = NULL, Outputs = NULL, DataCatalogOutputs = NULL, DatabaseOutputs = NULL, RoleArn, Timeout = NULL) {
  op <- new_operation(
    name = "UpdateRecipeJob",
    http_method = "PUT",
    http_path = "/recipeJobs/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_recipe_job_input(EncryptionKeyArn = EncryptionKeyArn, EncryptionMode = EncryptionMode, Name = Name, LogSubscription = LogSubscription, MaxCapacity = MaxCapacity, MaxRetries = MaxRetries, Outputs = Outputs, DataCatalogOutputs = DataCatalogOutputs, DatabaseOutputs = DatabaseOutputs, RoleArn = RoleArn, Timeout = Timeout)
  output <- .gluedatabrew$update_recipe_job_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_recipe_job <- gluedatabrew_update_recipe_job

#' Updates specified ruleset
#'
#' @description
#' Updates specified ruleset.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_ruleset/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_ruleset/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the ruleset to be updated.
#' @param Description The description of the ruleset.
#' @param Rules &#91;required&#93; A list of rules that are defined with the ruleset. A rule includes one
#' or more checks to be validated on a DataBrew dataset.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_ruleset
gluedatabrew_update_ruleset <- function(Name, Description = NULL, Rules) {
  op <- new_operation(
    name = "UpdateRuleset",
    http_method = "PUT",
    http_path = "/rulesets/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_ruleset_input(Name = Name, Description = Description, Rules = Rules)
  output <- .gluedatabrew$update_ruleset_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_ruleset <- gluedatabrew_update_ruleset

#' Modifies the definition of an existing DataBrew schedule
#'
#' @description
#' Modifies the definition of an existing DataBrew schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/gluedatabrew_update_schedule/](https://www.paws-r-sdk.com/docs/gluedatabrew_update_schedule/) for full documentation.
#'
#' @param JobNames The name or names of one or more jobs to be run for this schedule.
#' @param CronExpression &#91;required&#93; The date or dates and time or times when the jobs are to be run. For
#' more information, see [Cron
#' expressions](https://docs.aws.amazon.com/databrew/latest/dg/) in the
#' *Glue DataBrew Developer Guide*.
#' @param Name &#91;required&#93; The name of the schedule to update.
#'
#' @keywords internal
#'
#' @rdname gluedatabrew_update_schedule
gluedatabrew_update_schedule <- function(JobNames = NULL, CronExpression, Name) {
  op <- new_operation(
    name = "UpdateSchedule",
    http_method = "PUT",
    http_path = "/schedules/{name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .gluedatabrew$update_schedule_input(JobNames = JobNames, CronExpression = CronExpression, Name = Name)
  output <- .gluedatabrew$update_schedule_output()
  config <- get_config()
  svc <- .gluedatabrew$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.gluedatabrew$operations$update_schedule <- gluedatabrew_update_schedule
