% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_list_closed_workflow_executions}
\alias{swf_list_closed_workflow_executions}
\title{Returns a list of closed workflow executions in the specified domain
that meet the filtering criteria}
\usage{
swf_list_closed_workflow_executions(domain, startTimeFilter,
  closeTimeFilter, executionFilter, closeStatusFilter, typeFilter,
  tagFilter, nextPageToken, maximumPageSize, reverseOrder)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the workflow executions to list.}

\item{startTimeFilter}{If specified, the workflow executions are included in the returned
results based on whether their start times are within the range
specified by this filter. Also, if this parameter is specified, the
returned results are ordered by their start times.

\code{startTimeFilter} and \code{closeTimeFilter} are mutually exclusive. You must
specify one of these in a request but not both.}

\item{closeTimeFilter}{If specified, the workflow executions are included in the returned
results based on whether their close times are within the range
specified by this filter. Also, if this parameter is specified, the
returned results are ordered by their close times.

\code{startTimeFilter} and \code{closeTimeFilter} are mutually exclusive. You must
specify one of these in a request but not both.}

\item{executionFilter}{If specified, only workflow executions matching the workflow ID
specified in the filter are returned.

\code{closeStatusFilter}, \code{executionFilter}, \code{typeFilter} and \code{tagFilter} are
mutually exclusive. You can specify at most one of these in a request.}

\item{closeStatusFilter}{If specified, only workflow executions that match this \emph{close status}
are listed. For example, if TERMINATED is specified, then only
TERMINATED workflow executions are listed.

\code{closeStatusFilter}, \code{executionFilter}, \code{typeFilter} and \code{tagFilter} are
mutually exclusive. You can specify at most one of these in a request.}

\item{typeFilter}{If specified, only executions of the type specified in the filter are
returned.

\code{closeStatusFilter}, \code{executionFilter}, \code{typeFilter} and \code{tagFilter} are
mutually exclusive. You can specify at most one of these in a request.}

\item{tagFilter}{If specified, only executions that have the matching tag are listed.

\code{closeStatusFilter}, \code{executionFilter}, \code{typeFilter} and \code{tagFilter} are
mutually exclusive. You can specify at most one of these in a request.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
60 seconds. Using an expired pagination token will return a \code{400} error:
"\verb{Specified token has exceeded its maximum lifetime}".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.}

\item{reverseOrder}{When set to \code{true}, returns the results in reverse order. By default the
results are returned in descending order of the start or the close time
of the executions.}
}
\description{
Returns a list of closed workflow executions in the specified domain
that meet the filtering criteria. The results may be split into multiple
pages. To retrieve subsequent pages, make the call again using the
nextPageToken returned by the initial call.

This operation is eventually consistent. The results are best effort and
may not exactly reflect recent updates and changes.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the following parameters by using a \code{Condition} element
with the appropriate keys.
\itemize{
\item \code{tagFilter.tag}: String constraint. The key is
\code{swf:tagFilter.tag}.
\item \code{typeFilter.name}: String constraint. The key is
\code{swf:typeFilter.name}.
\item \code{typeFilter.version}: String constraint. The key is
\code{swf:typeFilter.version}.
}
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_closed_workflow_executions(
  domain = "string",
  startTimeFilter = list(
    oldestDate = as.POSIXct(
      "2015-01-01"
    ),
    latestDate = as.POSIXct(
      "2015-01-01"
    )
  ),
  closeTimeFilter = list(
    oldestDate = as.POSIXct(
      "2015-01-01"
    ),
    latestDate = as.POSIXct(
      "2015-01-01"
    )
  ),
  executionFilter = list(
    workflowId = "string"
  ),
  closeStatusFilter = list(
    status = "COMPLETED"|"FAILED"|"CANCELED"|"TERMINATED"|"CONTINUED_AS_NEW"|"TIMED_OUT"
  ),
  typeFilter = list(
    name = "string",
    version = "string"
  ),
  tagFilter = list(
    tag = "string"
  ),
  nextPageToken = "string",
  maximumPageSize = 123,
  reverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
