% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_list_state_machines}
\alias{sfn_list_state_machines}
\title{Lists the existing state machines}
\usage{
sfn_list_state_machines(maxResults, nextToken)
}
\arguments{
\item{maxResults}{The maximum number of results that are returned per call. You can use
\code{nextToken} to obtain further pages of results. The default is 100 and
the maximum allowed page size is 1000. A value of 0 uses the default.

This is only an upper limit. The actual number of results returned per
call might be fewer than the specified maximum.}

\item{nextToken}{If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.}
}
\description{
Lists the existing state machines.
}
\details{
If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.

This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.
}
\section{Request syntax}{
\preformatted{svc$list_state_machines(
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
