% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_send_task_success}
\alias{sfn_send_task_success}
\title{Used by activity workers and task states using the callback pattern to
report that the task identified by the taskToken completed successfully}
\usage{
sfn_send_task_success(taskToken, output)
}
\arguments{
\item{taskToken}{[required] The token that represents this task. Task tokens are generated by Step
Functions when tasks are assigned to a worker, or in the \href{https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html}{context object}
when a workflow enters a task state. See
GetActivityTaskOutput$taskToken.}

\item{output}{[required] The JSON output of the task. Length constraints apply to the payload
size, and are expressed as bytes in UTF-8 encoding.}
}
\description{
Used by activity workers and task states using the \href{https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token}{callback} pattern to report that the task identified by the \code{taskToken} completed successfully.

See \url{https://www.paws-r-sdk.com/docs/sfn_send_task_success/} for full documentation.
}
\keyword{internal}
