% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_verify_device_position}
\alias{locationservice_verify_device_position}
\title{Verifies the integrity of the device's position by determining if it was
reported behind a proxy, and by comparing it to an inferred position
estimated based on the device's state}
\usage{
locationservice_verify_device_position(
  TrackerName,
  DeviceState,
  DistanceUnit = NULL
)
}
\arguments{
\item{TrackerName}{[required] The name of the tracker resource to be associated with verification
request.}

\item{DeviceState}{[required] The device's state, including position, IP address, cell signals and
Wi-Fi access points.}

\item{DistanceUnit}{The distance unit for the verification request.

Default Value: \code{Kilometers}}
}
\description{
Verifies the integrity of the device's position by determining if it was reported behind a proxy, and by comparing it to an inferred position estimated based on the device's state.

See \url{https://www.paws-r-sdk.com/docs/locationservice_verify_device_position/} for full documentation.
}
\keyword{internal}
