% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourceexplorer_operations.R
\name{resourceexplorer_create_view}
\alias{resourceexplorer_create_view}
\title{Creates a view that users can query by using the Search operation}
\usage{
resourceexplorer_create_view(
  ClientToken = NULL,
  Filters = NULL,
  IncludedProperties = NULL,
  Scope = NULL,
  Tags = NULL,
  ViewName
)
}
\arguments{
\item{ClientToken}{This value helps ensure idempotency. Resource Explorer uses this value
to prevent the accidental creation of duplicate versions. We recommend
that you generate a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID-type value} to
ensure the uniqueness of your views.}

\item{Filters}{An array of strings that specify which resources are included in the
results of queries made using this view. When you use this view in a
\code{\link[=resourceexplorer_search]{search}} operation, the filter string is
combined with the search's \code{QueryString} parameter using a logical \code{AND}
operator.

For information about the supported syntax, see \href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html}{Search query reference for Resource Explorer}
in the \emph{Amazon Web Services Resource Explorer User Guide}.

This query string in the context of this operation supports only \href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters}{filter prefixes}
with optional
\href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators}{operators}.
It doesn't support free-form text. For example, the string
\code{region:us* service:ec2 -tag:stage=prod} includes all Amazon EC2
resources in any Amazon Web Services Region that begins with the letters
\code{us} and is \emph{not} tagged with a key \code{Stage} that has the value \code{prod}.}

\item{IncludedProperties}{Specifies optional fields that you want included in search results from
this view. It is a list of objects that each describe a field to
include.

The default is an empty list, with no optional fields included in the
results.}

\item{Scope}{The root ARN of the account, an organizational unit (OU), or an
organization ARN. If left empty, the default is account.}

\item{Tags}{Tag key and value pairs that are attached to the view.}

\item{ViewName}{[required] The name of the new view. This name appears in the list of views in
Resource Explorer.

The name must be no more than 64 characters long, and can include
letters, digits, and the dash (-) character. The name must be unique
within its Amazon Web Services Region.}
}
\description{
Creates a view that users can query by using the \code{\link[=resourceexplorer_search]{search}} operation. Results from queries that you make using this view include only resources that match the view's \code{Filters}. For more information about Amazon Web Services Resource Explorer views, see \href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html}{Managing views} in the \emph{Amazon Web Services Resource Explorer User Guide}.

See \url{https://www.paws-r-sdk.com/docs/resourceexplorer_create_view/} for full documentation.
}
\keyword{internal}
