% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{set_config}
\alias{set_config}
\title{Add configuration settings to a service object.}
\usage{
set_config(svc, cfgs = list())
}
\arguments{
\item{svc}{A service object containing service operations.}

\item{cfgs}{A list of optional configuration settings.}
}
\description{
\code{set_config} adds a given set of configuration settings in \code{cfgs} to a
service object, i.e. the service object for S3. Configuration settings can
include credentials, region, endpoint, etc. These configuration settings
will be used whenever an operation is called from that service object.
}
\details{
\code{set_config} explicitly makes the \code{credentials} property mutable, such that
when the SDK retrieves credentials later on, it will save them in the
service object. This means that credentials don't need to be fetched on each
operation, only if and when the saved credentials expire.

The optional configuration settings can include the following:\preformatted{list(
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string"
  ),
  endpoint = "string",
  region = "string"
)
}
}
\examples{
# Create a config object with custom credentials and endpoint.
config <- set_config(
  svc = list(),
  cfgs = list(
    credentials = list(
      creds = list(
        access_key_id = "abc",
        secret_access_key = "123"
      )
    ),
    endpoint = "https://foo.com"
  )
)

}
