test_that("StreamHandler", {
  op <- Operation(name = "SelectObjectContent")
  svc <- Client()
  svc$client_info$service_name <- "s3"
  svc$handlers$unmarshal <- HandlerList(restxml_unmarshal)
  op_output <- Structure(
    Payload = Structure(
      Records = Structure(
        Payload = Scalar(.tags = list(eventpayload = TRUE, type = "blob"))
      ),
      Stats = Structure(
        Details = Structure(
          BytesScanned = Scalar(.tags = list(type = "long")),
          BytesProcessed = Scalar(.tags = list(type = "long")),
          BytesReturned = Scalar(.tags = list(type = "long")),
          .tags = list(eventpayload = TRUE)
        )
      ),
      Progress = Structure(
        Details = Structure(
          BytesScanned = Scalar(.tags = list(type = "long")),
          BytesProcessed = Scalar(.tags = list(type = "long")),
          BytesReturned = Scalar(.tags = list(type = "long")),
          .tags = list(eventpayload = TRUE)
        )
      ),
      Cont = Scalar(.tags = list(event = TRUE)),
      End = Scalar(.tags = list(event = TRUE))
    ),
    .tags = list(payload = "Payload")
  )

  req <- new_request(svc, op, NULL, op_output)
  req$operation$stream_api <- TRUE
  req$http_response <- HttpResponse(status_code = 200, body = list())
  req <- unmarshal(req)
  expect_named(req$data, "Payload")
  expect_s3_class(req$data$Payload, "PawsStreamHandler")
  expect_equal(
    capture.output(req$data$Payload),
    c(
      "<PawsStreamHandler>",
      "Please check return object for: s3_select_object_content",
      "https://www.paws-r-sdk.com/docs/s3_select_object_content/"
    )
  )
})

test_that("check xml paws_stream_parser", {
  body <- as.raw(c(
    0x00,
    0x00,
    0x00,
    0x6b,
    0x00,
    0x00,
    0x00,
    0x55,
    0x90,
    0xc1,
    0x3c,
    0x4e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x07,
    0x52,
    0x65,
    0x63,
    0x6f,
    0x72,
    0x64,
    0x73,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x18,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6f,
    0x63,
    0x74,
    0x65,
    0x74,
    0x2d,
    0x73,
    0x74,
    0x72,
    0x65,
    0x61,
    0x6d,
    0x31,
    0x0a,
    0x32,
    0x0a,
    0x33,
    0x0a,
    0x60,
    0x17,
    0xc3,
    0x4c,
    0x00,
    0x00,
    0x00,
    0xcd,
    0x00,
    0x00,
    0x00,
    0x43,
    0x9b,
    0x72,
    0xe3,
    0x29,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x53,
    0x74,
    0x61,
    0x74,
    0x73,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x08,
    0x74,
    0x65,
    0x78,
    0x74,
    0x2f,
    0x78,
    0x6d,
    0x6c,
    0x3c,
    0x53,
    0x74,
    0x61,
    0x74,
    0x73,
    0x20,
    0x78,
    0x6d,
    0x6c,
    0x6e,
    0x73,
    0x3d,
    0x22,
    0x22,
    0x3e,
    0x3c,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x53,
    0x63,
    0x61,
    0x6e,
    0x6e,
    0x65,
    0x64,
    0x3e,
    0x31,
    0x30,
    0x3c,
    0x2f,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x53,
    0x63,
    0x61,
    0x6e,
    0x6e,
    0x65,
    0x64,
    0x3e,
    0x3c,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x50,
    0x72,
    0x6f,
    0x63,
    0x65,
    0x73,
    0x73,
    0x65,
    0x64,
    0x3e,
    0x31,
    0x30,
    0x3c,
    0x2f,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x50,
    0x72,
    0x6f,
    0x63,
    0x65,
    0x73,
    0x73,
    0x65,
    0x64,
    0x3e,
    0x3c,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x52,
    0x65,
    0x74,
    0x75,
    0x72,
    0x6e,
    0x65,
    0x64,
    0x3e,
    0x36,
    0x3c,
    0x2f,
    0x42,
    0x79,
    0x74,
    0x65,
    0x73,
    0x52,
    0x65,
    0x74,
    0x75,
    0x72,
    0x6e,
    0x65,
    0x64,
    0x3e,
    0x3c,
    0x2f,
    0x53,
    0x74,
    0x61,
    0x74,
    0x73,
    0x3e,
    0x40,
    0xc6,
    0x94,
    0x33,
    0x00,
    0x00,
    0x00,
    0x38,
    0x00,
    0x00,
    0x00,
    0x28,
    0xc1,
    0xc6,
    0x84,
    0xd4,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x03,
    0x45,
    0x6e,
    0x64,
    0xcf,
    0x97,
    0xd3,
    0x92
  ))

  interface <- structure(
    list(
      Records = structure(
        list(
          Payload = structure(logical(0), tags = list(eventpayload = TRUE, type = "blob"))
        ),
        tags = list(type = "structure", event = TRUE)
      ),
      Stats = structure(
        list(
          Details = structure(
            list(
              BytesScanned = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              ),
              BytesProcessed = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              ),
              BytesReturned = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              )
            ),
            tags = list(eventpayload = TRUE, type = "structure")
          )
        ),
        tags = list(type = "structure", event = TRUE)
      ),
      Progress = structure(
        list(
          Details = structure(
            list(
              BytesScanned = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              ),
              BytesProcessed = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              ),
              BytesReturned = structure(
                logical(0),
                tags = list(type = "long", box = TRUE)
              )
            ),
            tags = list(eventpayload = TRUE, type = "structure")
          )
        ),
        tags = list(type = "structure", event = TRUE)
      ),
      Cont = structure(list(), tags = list(type = "structure", event = TRUE)),
      End = structure(list(), tags = list(type = "structure", event = TRUE))
    ),
    tags = list(type = "structure", eventstream = TRUE)
  )

  # mock con object
  con <- list(
    body = rawConnection(body),
    paws_metadata = list(unmarshal = xml_parse_stream, interface = interface)
  )

  mock_isIncomplete <- mock2(TRUE)
  mockery::stub(paws_stream_parser, "isIncomplete", mock_isIncomplete)

  actual <- paws_stream_parser(con)
  close(con$body)

  expect_equal(rawToChar(actual$Records$Payload), "1\n2\n3\n")
  expect_equal(
    actual$Stats,
    list(Details = list(BytesScanned = 10, BytesProcessed = 10, BytesReturned = 6))
  )
})

test_that("check json paws_stream_parser", {
  body <- as.raw(c(
    0x00,
    0x00,
    0x00,
    0xaa,
    0x00,
    0x00,
    0x00,
    0x52,
    0xda,
    0xd0,
    0x68,
    0x86,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x0c,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x53,
    0x74,
    0x61,
    0x72,
    0x74,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6a,
    0x73,
    0x6f,
    0x6e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x7b,
    0x22,
    0x70,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x22,
    0x2c,
    0x22,
    0x72,
    0x6f,
    0x6c,
    0x65,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x73,
    0x73,
    0x69,
    0x73,
    0x74,
    0x61,
    0x6e,
    0x74,
    0x22,
    0x7d,
    0x72,
    0x03,
    0x3e,
    0x7b,
    0x00,
    0x00,
    0x01,
    0x5d,
    0x00,
    0x00,
    0x00,
    0x57,
    0x9b,
    0xf2,
    0xc3,
    0xe1,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x11,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x42,
    0x6c,
    0x6f,
    0x63,
    0x6b,
    0x44,
    0x65,
    0x6c,
    0x74,
    0x61,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6a,
    0x73,
    0x6f,
    0x6e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x7b,
    0x22,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x42,
    0x6c,
    0x6f,
    0x63,
    0x6b,
    0x49,
    0x6e,
    0x64,
    0x65,
    0x78,
    0x22,
    0x3a,
    0x30,
    0x2c,
    0x22,
    0x64,
    0x65,
    0x6c,
    0x74,
    0x61,
    0x22,
    0x3a,
    0x7b,
    0x22,
    0x74,
    0x65,
    0x78,
    0x74,
    0x22,
    0x3a,
    0x22,
    0x49,
    0x20,
    0x61,
    0x6d,
    0x20,
    0x41,
    0x6d,
    0x61,
    0x7a,
    0x6f,
    0x6e,
    0x20,
    0x54,
    0x69,
    0x74,
    0x61,
    0x6e,
    0x2c,
    0x20,
    0x61,
    0x20,
    0x6c,
    0x61,
    0x72,
    0x67,
    0x65,
    0x20,
    0x6c,
    0x61,
    0x6e,
    0x67,
    0x75,
    0x61,
    0x67,
    0x65,
    0x20,
    0x6d,
    0x6f,
    0x64,
    0x65,
    0x6c,
    0x20,
    0x62,
    0x75,
    0x69,
    0x6c,
    0x74,
    0x20,
    0x62,
    0x79,
    0x20,
    0x41,
    0x57,
    0x53,
    0x2e,
    0x20,
    0x49,
    0x20,
    0x77,
    0x61,
    0x73,
    0x20,
    0x64,
    0x65,
    0x73,
    0x69,
    0x67,
    0x6e,
    0x65,
    0x64,
    0x20,
    0x74,
    0x6f,
    0x20,
    0x61,
    0x73,
    0x73,
    0x69,
    0x73,
    0x74,
    0x20,
    0x79,
    0x6f,
    0x75,
    0x20,
    0x77,
    0x69,
    0x74,
    0x68,
    0x20,
    0x74,
    0x61,
    0x73,
    0x6b,
    0x73,
    0x20,
    0x6f,
    0x72,
    0x20,
    0x61,
    0x6e,
    0x73,
    0x77,
    0x65,
    0x72,
    0x20,
    0x61,
    0x6e,
    0x79,
    0x20,
    0x71,
    0x75,
    0x65,
    0x73,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x73,
    0x20,
    0x79,
    0x6f,
    0x75,
    0x20,
    0x6d,
    0x61,
    0x79,
    0x20,
    0x68,
    0x61,
    0x76,
    0x65,
    0x2e,
    0x20,
    0x48,
    0x6f,
    0x77,
    0x20,
    0x6d,
    0x61,
    0x79,
    0x20,
    0x49,
    0x20,
    0x68,
    0x65,
    0x6c,
    0x70,
    0x20,
    0x79,
    0x6f,
    0x75,
    0x3f,
    0x22,
    0x7d,
    0x2c,
    0x22,
    0x70,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x22,
    0x7d,
    0x08,
    0x31,
    0x0d,
    0x02,
    0x00,
    0x00,
    0x00,
    0xb7,
    0x00,
    0x00,
    0x00,
    0x56,
    0x45,
    0xcd,
    0xff,
    0xac,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x42,
    0x6c,
    0x6f,
    0x63,
    0x6b,
    0x53,
    0x74,
    0x6f,
    0x70,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6a,
    0x73,
    0x6f,
    0x6e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x7b,
    0x22,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x42,
    0x6c,
    0x6f,
    0x63,
    0x6b,
    0x49,
    0x6e,
    0x64,
    0x65,
    0x78,
    0x22,
    0x3a,
    0x30,
    0x2c,
    0x22,
    0x70,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x22,
    0x7d,
    0x4c,
    0xb1,
    0xd4,
    0x91,
    0x00,
    0x00,
    0x00,
    0xb4,
    0x00,
    0x00,
    0x00,
    0x51,
    0x9c,
    0x09,
    0x10,
    0xdf,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x0b,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x53,
    0x74,
    0x6f,
    0x70,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6a,
    0x73,
    0x6f,
    0x6e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x7b,
    0x22,
    0x70,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x22,
    0x2c,
    0x22,
    0x73,
    0x74,
    0x6f,
    0x70,
    0x52,
    0x65,
    0x61,
    0x73,
    0x6f,
    0x6e,
    0x22,
    0x3a,
    0x22,
    0x65,
    0x6e,
    0x64,
    0x5f,
    0x74,
    0x75,
    0x72,
    0x6e,
    0x22,
    0x7d,
    0xbe,
    0x58,
    0x0a,
    0xc7,
    0x00,
    0x00,
    0x00,
    0xfe,
    0x00,
    0x00,
    0x00,
    0x4e,
    0x03,
    0x42,
    0x5d,
    0xc2,
    0x0b,
    0x3a,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x08,
    0x6d,
    0x65,
    0x74,
    0x61,
    0x64,
    0x61,
    0x74,
    0x61,
    0x0d,
    0x3a,
    0x63,
    0x6f,
    0x6e,
    0x74,
    0x65,
    0x6e,
    0x74,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x10,
    0x61,
    0x70,
    0x70,
    0x6c,
    0x69,
    0x63,
    0x61,
    0x74,
    0x69,
    0x6f,
    0x6e,
    0x2f,
    0x6a,
    0x73,
    0x6f,
    0x6e,
    0x0d,
    0x3a,
    0x6d,
    0x65,
    0x73,
    0x73,
    0x61,
    0x67,
    0x65,
    0x2d,
    0x74,
    0x79,
    0x70,
    0x65,
    0x07,
    0x00,
    0x05,
    0x65,
    0x76,
    0x65,
    0x6e,
    0x74,
    0x7b,
    0x22,
    0x6d,
    0x65,
    0x74,
    0x72,
    0x69,
    0x63,
    0x73,
    0x22,
    0x3a,
    0x7b,
    0x22,
    0x6c,
    0x61,
    0x74,
    0x65,
    0x6e,
    0x63,
    0x79,
    0x4d,
    0x73,
    0x22,
    0x3a,
    0x31,
    0x34,
    0x32,
    0x30,
    0x7d,
    0x2c,
    0x22,
    0x70,
    0x22,
    0x3a,
    0x22,
    0x61,
    0x62,
    0x63,
    0x22,
    0x2c,
    0x22,
    0x75,
    0x73,
    0x61,
    0x67,
    0x65,
    0x22,
    0x3a,
    0x7b,
    0x22,
    0x63,
    0x61,
    0x63,
    0x68,
    0x65,
    0x52,
    0x65,
    0x61,
    0x64,
    0x49,
    0x6e,
    0x70,
    0x75,
    0x74,
    0x54,
    0x6f,
    0x6b,
    0x65,
    0x6e,
    0x43,
    0x6f,
    0x75,
    0x6e,
    0x74,
    0x22,
    0x3a,
    0x30,
    0x2c,
    0x22,
    0x63,
    0x61,
    0x63,
    0x68,
    0x65,
    0x57,
    0x72,
    0x69,
    0x74,
    0x65,
    0x49,
    0x6e,
    0x70,
    0x75,
    0x74,
    0x54,
    0x6f,
    0x6b,
    0x65,
    0x6e,
    0x43,
    0x6f,
    0x75,
    0x6e,
    0x74,
    0x22,
    0x3a,
    0x30,
    0x2c,
    0x22,
    0x69,
    0x6e,
    0x70,
    0x75,
    0x74,
    0x54,
    0x6f,
    0x6b,
    0x65,
    0x6e,
    0x73,
    0x22,
    0x3a,
    0x38,
    0x2c,
    0x22,
    0x6f,
    0x75,
    0x74,
    0x70,
    0x75,
    0x74,
    0x54,
    0x6f,
    0x6b,
    0x65,
    0x6e,
    0x73,
    0x22,
    0x3a,
    0x33,
    0x39,
    0x2c,
    0x22,
    0x74,
    0x6f,
    0x74,
    0x61,
    0x6c,
    0x54,
    0x6f,
    0x6b,
    0x65,
    0x6e,
    0x73,
    0x22,
    0x3a,
    0x34,
    0x37,
    0x7d,
    0x7d,
    0xff,
    0xaa,
    0x2c,
    0xb4
  ))
  interface <- structure(list(
    contentBlockDelta = structure(
      list(
        delta = structure(
          list(
            text = structure(logical(0), tags = list(type = "string")),
            toolUse = structure(
              list(input = structure(logical(0), tags = list(type = "string"))),
              tags = list(type = "structure")
            )
          ),
          tags = list(type = "structure", union = TRUE)
        ),
        contentBlockIndex = structure(
          logical(0),
          tags = list(type = "integer", box = TRUE)
        )
      ),
      tags = list(type = "structure", event = TRUE)
    ),
    messageStop = structure(
      list(
        stopReason = structure(logical(0), tags = list(type = "string")),
        additionalModelResponseFields = structure(
          list(),
          tags = list(type = "structure", document = TRUE)
        )
      ),
      tags = list(type = "structure", event = TRUE)
    )
  ))

  # mock con object
  con <- list(
    body = rawConnection(body),
    paws_metadata = list(unmarshal = json_parse_stream, interface = interface)
  )

  mock_isIncomplete <- mock2(TRUE)
  mockery::stub(paws_stream_parser, "isIncomplete", mock_isIncomplete)

  actual <- paws_stream_parser(con)
  close(con$body)

  expect_equal(
    actual$contentBlockDelta$delta$text,
    "I am Amazon Titan, a large language model built by AWS. I was designed to assist you with tasks or answer any questions you may have. How may I help you?"
  )
  expect_equal(actual$messageStop$stopReason, "end_turn")
})

test_that("check stream_raw", {
  mock_isIncomplete <- mock2(TRUE, FALSE)
  mockery::stub(stream_raw, "isIncomplete", mock_isIncomplete)

  bytes <- as.raw(as.integer(runif(100) * 100))
  con <- rawConnection(bytes)

  actual <- stream_raw(con)

  expect_equal(actual, bytes)
})

test_that("check validate_checksum failure", {
  data <- as.raw(c(0x1c, 0x48, 0x35, 0x5a))
  expect_error(validate_checksum(data, "05321e05"), "Checksum mismatch")
})
