% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_function_event_invoke_configs}
\alias{lambda_list_function_event_invoke_configs}
\title{Retrieves a list of configurations for asynchronous invocation for a
function}
\usage{
lambda_list_function_event_invoke_configs(FunctionName, Marker,
  MaxItems)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{The maximum number of configurations to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  FunctionEventInvokeConfigs = list(
    list(
      LastModified = as.POSIXct(
        "2015-01-01"
      ),
      FunctionArn = "string",
      MaximumRetryAttempts = 123,
      MaximumEventAgeInSeconds = 123,
      DestinationConfig = list(
        OnSuccess = list(
          Destination = "string"
        ),
        OnFailure = list(
          Destination = "string"
        )
      )
    )
  ),
  NextMarker = "string"
)
}
}
\description{
Retrieves a list of configurations for asynchronous invocation for a
function.

To configure options for asynchronous invocation, use
\code{\link[=lambda_put_function_event_invoke_config]{put_function_event_invoke_config}}.
}
\section{Request syntax}{
\preformatted{svc$list_function_event_invoke_configs(
  FunctionName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following example returns a list of asynchronous invocation
# configurations for a function named my-function.
svc$list_function_event_invoke_configs(
  FunctionName = "my-function"
)
}

}
\keyword{internal}
