% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_functions}
\alias{lambda_list_functions}
\title{Returns a list of Lambda functions, with the version-specific
configuration of each}
\usage{
lambda_list_functions(MasterRegion, FunctionVersion, Marker, MaxItems)
}
\arguments{
\item{MasterRegion}{For Lambda@Edge functions, the AWS Region of the master function. For
example, \code{us-east-1} filters the list of functions to only include
Lambda@Edge functions replicated from a master function in US East (N.
Virginia). If specified, you must set \code{FunctionVersion} to \code{ALL}.}

\item{FunctionVersion}{Set to \code{ALL} to include entries for all published versions of each
function.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{The maximum number of functions to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextMarker = "string",
  Functions = list(
    list(
      FunctionName = "string",
      FunctionArn = "string",
      Runtime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2",
      Role = "string",
      Handler = "string",
      CodeSize = 123,
      Description = "string",
      Timeout = 123,
      MemorySize = 123,
      LastModified = "string",
      CodeSha256 = "string",
      Version = "string",
      VpcConfig = list(
        SubnetIds = list(
          "string"
        ),
        SecurityGroupIds = list(
          "string"
        ),
        VpcId = "string"
      ),
      DeadLetterConfig = list(
        TargetArn = "string"
      ),
      Environment = list(
        Variables = list(
          "string"
        ),
        Error = list(
          ErrorCode = "string",
          Message = "string"
        )
      ),
      KMSKeyArn = "string",
      TracingConfig = list(
        Mode = "Active"|"PassThrough"
      ),
      MasterArn = "string",
      RevisionId = "string",
      Layers = list(
        list(
          Arn = "string",
          CodeSize = 123,
          SigningProfileVersionArn = "string",
          SigningJobArn = "string"
        )
      ),
      State = "Pending"|"Active"|"Inactive"|"Failed",
      StateReason = "string",
      StateReasonCode = "Idle"|"Creating"|"Restoring"|"EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
      LastUpdateStatus = "Successful"|"Failed"|"InProgress",
      LastUpdateStatusReason = "string",
      LastUpdateStatusReasonCode = "EniLimitExceeded"|"InsufficientRolePermissions"|"InvalidConfiguration"|"InternalError"|"SubnetOutOfIPAddresses"|"InvalidSubnet"|"InvalidSecurityGroup"|"ImageDeleted"|"ImageAccessDenied"|"InvalidImage",
      FileSystemConfigs = list(
        list(
          Arn = "string",
          LocalMountPath = "string"
        )
      ),
      PackageType = "Zip"|"Image",
      ImageConfigResponse = list(
        ImageConfig = list(
          EntryPoint = list(
            "string"
          ),
          Command = list(
            "string"
          ),
          WorkingDirectory = "string"
        ),
        Error = list(
          ErrorCode = "string",
          Message = "string"
        )
      ),
      SigningProfileVersionArn = "string",
      SigningJobArn = "string"
    )
  )
)
}
}
\description{
Returns a list of Lambda functions, with the version-specific
configuration of each. Lambda returns up to 50 functions per call.

Set \code{FunctionVersion} to \code{ALL} to include all published versions of each
function in addition to the unpublished version. To get more information
about a function or version, use \code{\link[=lambda_get_function]{get_function}}.
}
\section{Request syntax}{
\preformatted{svc$list_functions(
  MasterRegion = "string",
  FunctionVersion = "ALL",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# This operation returns a list of Lambda functions.
svc$list_functions()
}

}
\keyword{internal}
